/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.mru;

import com.sshtools.common.mru.MRUListModel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class MRUMenu
extends JMenu
implements ListDataListener,
ActionListener {
    private MRUListModel model;

    protected MRUMenu(Action action, MRUListModel mRUListModel) {
        super(action);
        this.init(mRUListModel);
    }

    protected MRUMenu(String string, MRUListModel mRUListModel) {
        super(string);
        this.init(mRUListModel);
    }

    private void init(MRUListModel mRUListModel) {
        this.model = mRUListModel;
        this.rebuildMenu();
        mRUListModel.addListDataListener(this);
    }

    public void cleanUp() {
        this.model.removeListDataListener(this);
    }

    public void intervalAdded(ListDataEvent listDataEvent) {
        this.rebuildMenu();
    }

    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.rebuildMenu();
    }

    public void contentsChanged(ListDataEvent listDataEvent) {
        this.rebuildMenu();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.fireActionPerformed(actionEvent);
    }

    private void rebuildMenu() {
        int n;
        Component[] componentArray = this.getMenuComponents();
        for (n = 0; componentArray != null && n < componentArray.length; ++n) {
            ((JMenuItem)componentArray[n]).removeActionListener(this);
            this.remove(componentArray[n]);
        }
        for (n = 0; n < this.model.getSize(); ++n) {
            File file = (File)this.model.getElementAt(n);
            JMenuItem jMenuItem = new JMenuItem(file.getName());
            jMenuItem.setActionCommand(file.getAbsolutePath());
            jMenuItem.setToolTipText(file.getAbsolutePath());
            jMenuItem.addActionListener(this);
            this.add(jMenuItem);
        }
        this.setEnabled(this.model.getSize() > 0);
        this.validate();
    }
}

