/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.MatteBorder;

public class PrintPreview
extends JPanel
implements ActionListener,
Runnable {
    protected PrinterJob job;
    protected JButton setup;
    protected JComboBox scale;
    protected int pageWidth;
    protected Printable printable;
    protected PreviewContainer previewer;
    protected PageFormat pageFormat;
    protected int pageHeight;
    protected JScrollPane scrollpane;

    public PrintPreview(Printable printable, PageFormat pageFormat) {
        super(new BorderLayout());
        this.printable = printable;
        this.job = PrinterJob.getPrinterJob();
        this.pageFormat = pageFormat;
        JPanel jPanel = new JPanel(new FlowLayout(0, 2, 2));
        this.setup = new JButton("Setup");
        this.setup.addActionListener(this);
        this.setup.setMnemonic('p');
        jPanel.add(this.setup);
        String[] stringArray = new String[]{"10 %", "25 %", "50 %", "75 %", "100 %", "200 %"};
        this.scale = new JComboBox<String>(stringArray);
        this.scale.setSelectedItem(stringArray[2]);
        this.scale.addActionListener(this);
        this.scale.setEditable(true);
        jPanel.add(this.scale);
        this.add((Component)jPanel, "North");
        this.previewer = new PreviewContainer();
        if (pageFormat.getHeight() == 0.0 || pageFormat.getWidth() == 0.0) {
            System.err.println("Unable to determine default page size");
            return;
        }
        this.pageWidth = (int)pageFormat.getWidth();
        this.pageHeight = (int)pageFormat.getHeight();
        int n = 50;
        int n2 = this.pageWidth * n / 100;
        int n3 = this.pageHeight * n / 100;
        int n4 = 0;
        try {
            while (true) {
                BufferedImage bufferedImage = new BufferedImage(this.pageWidth, this.pageHeight, 1);
                Graphics graphics = bufferedImage.getGraphics();
                graphics.setColor(Color.white);
                graphics.fillRect(0, 0, this.pageWidth, this.pageHeight);
                if (printable.print(graphics, pageFormat, n4) == 0) {
                    PagePreview pagePreview = new PagePreview(n2, n3, bufferedImage);
                    this.previewer.add(pagePreview);
                    ++n4;
                    continue;
                }
                break;
            }
        }
        catch (PrinterException printerException) {
            printerException.printStackTrace();
            System.err.println("Printing error: " + printerException.toString());
        }
        this.scrollpane = new JScrollPane(this.previewer);
        this.add((Component)this.scrollpane, "Center");
    }

    public PageFormat getPageFormat() {
        return this.pageFormat;
    }

    private void setup() {
        this.pageFormat = this.job.pageDialog(this.pageFormat);
        this.pageWidth = (int)this.pageFormat.getWidth();
        this.pageHeight = (int)this.pageFormat.getHeight();
        Thread thread = new Thread(this);
        thread.start();
    }

    public void run() {
        String string = this.scale.getSelectedItem().toString();
        this.scrollpane.setViewportView(new JLabel("Resizing"));
        if (string.endsWith("%")) {
            string = string.substring(0, string.length() - 1);
        }
        string = string.trim();
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            n = 100;
        }
        int n2 = this.pageWidth * n / 100;
        int n3 = this.pageHeight * n / 100;
        Component[] componentArray = this.previewer.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof PagePreview)) continue;
            PagePreview pagePreview = (PagePreview)componentArray[i];
            pagePreview.setScaledSize(n2, n3);
        }
        this.scrollpane.setViewportView(this.previewer);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.setup) {
            this.setup();
        } else if (actionEvent.getSource() == this.scale) {
            Thread thread = new Thread(this);
            thread.start();
        }
    }

    class PreviewContainer
    extends JPanel {
        protected int V_GAP = 10;
        protected int H_GAP = 16;

        PreviewContainer() {
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        public void doLayout() {
            Insets insets = this.getInsets();
            int n = insets.left + this.H_GAP;
            int n2 = insets.top + this.V_GAP;
            int n3 = this.getComponentCount();
            if (n3 == 0) {
                return;
            }
            Component component = this.getComponent(0);
            Dimension dimension = component.getPreferredSize();
            int n4 = dimension.width;
            int n5 = dimension.height;
            Dimension dimension2 = this.getParent().getSize();
            int n6 = Math.max((dimension2.width - this.H_GAP) / (n4 + this.H_GAP), 1);
            int n7 = n3 / n6;
            if (n7 * n6 < n3) {
                ++n7;
            }
            int n8 = 0;
            for (int i = 0; i < n7; ++i) {
                for (int j = 0; j < n6; ++j) {
                    if (n8 >= n3) {
                        return;
                    }
                    Component component2 = this.getComponent(n8++);
                    component2.setBounds(n, n2, n4, n5);
                    n += n4 + this.H_GAP;
                }
                n2 += n5 + this.V_GAP;
                n = insets.left + this.H_GAP;
            }
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getPreferredSize() {
            int n = this.getComponentCount();
            if (n == 0) {
                return new Dimension(this.H_GAP, this.V_GAP);
            }
            Component component = this.getComponent(0);
            Dimension dimension = component.getPreferredSize();
            int n2 = dimension.width;
            int n3 = dimension.height;
            Dimension dimension2 = this.getParent().getSize();
            int n4 = Math.max((dimension2.width - this.H_GAP) / (n2 + this.H_GAP), 1);
            int n5 = n / n4;
            if (n5 * n4 < n) {
                ++n5;
            }
            int n6 = n4 * (n2 + this.H_GAP) + this.H_GAP;
            int n7 = n5 * (n3 + this.V_GAP) + this.V_GAP;
            Insets insets = this.getInsets();
            return new Dimension(n6 + insets.left + insets.right, n7 + insets.top + insets.bottom);
        }
    }

    class PagePreview
    extends JPanel {
        protected int m_h;
        protected int m_w;
        protected Image m_img;
        protected Image m_source;

        public PagePreview(int n, int n2, Image image) {
            this.m_w = n;
            this.m_h = n2;
            this.m_source = image;
            this.m_img = this.m_source.getScaledInstance(this.m_w, this.m_h, 4);
            this.m_img.flush();
            this.setBackground(Color.white);
            this.setBorder(new MatteBorder(1, 1, 2, 2, Color.black));
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        public Dimension getPreferredSize() {
            Insets insets = this.getInsets();
            return new Dimension(this.m_w + insets.left + insets.right, this.m_h + insets.top + insets.bottom);
        }

        public void paint(Graphics graphics) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics.drawImage(this.m_img, 0, 0, this);
            this.paintBorder(graphics);
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public void setScaledSize(int n, int n2) {
            this.m_w = n;
            this.m_h = n2;
            this.m_img = this.m_source.getScaledInstance(this.m_w, this.m_h, 4);
            this.repaint();
        }
    }
}

