/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ui;

import com.sshtools.common.authentication.AuthenticationDialog;
import com.sshtools.common.authentication.BannerDialog;
import com.sshtools.common.authentication.KBIRequestHandlerDialog;
import com.sshtools.common.authentication.PasswordAuthenticationDialog;
import com.sshtools.common.authentication.PasswordChange;
import com.sshtools.common.authentication.PublicKeyAuthenticationPrompt;
import com.sshtools.common.automate.RemoteIdentification;
import com.sshtools.common.automate.RemoteIdentificationException;
import com.sshtools.common.automate.RemoteIdentificationFactory;
import com.sshtools.common.configuration.InvalidProfileFileException;
import com.sshtools.common.configuration.SshToolsConnectionProfile;
import com.sshtools.common.hosts.DialogKnownHostsKeyVerification;
import com.sshtools.common.ui.HostsTab;
import com.sshtools.common.ui.Option;
import com.sshtools.common.ui.OptionCallback;
import com.sshtools.common.ui.OptionsDialog;
import com.sshtools.common.ui.PreferencesStore;
import com.sshtools.common.ui.SshToolsApplication;
import com.sshtools.common.ui.SshToolsApplicationContainer;
import com.sshtools.common.ui.SshToolsApplicationException;
import com.sshtools.common.ui.SshToolsApplicationPanel;
import com.sshtools.common.ui.SshToolsConnectionPanel;
import com.sshtools.common.ui.SshToolsConnectionTab;
import com.sshtools.common.ui.StandardAction;
import com.sshtools.common.ui.UIUtil;
import com.sshtools.j2ssh.SshClient;
import com.sshtools.j2ssh.SshException;
import com.sshtools.j2ssh.SshThread;
import com.sshtools.j2ssh.agent.AgentAuthenticationClient;
import com.sshtools.j2ssh.agent.AgentNotAvailableException;
import com.sshtools.j2ssh.agent.SshAgentClient;
import com.sshtools.j2ssh.authentication.KBIAuthenticationClient;
import com.sshtools.j2ssh.authentication.KBIRequestHandler;
import com.sshtools.j2ssh.authentication.PasswordAuthenticationClient;
import com.sshtools.j2ssh.authentication.PasswordChangePrompt;
import com.sshtools.j2ssh.authentication.PublicKeyAuthenticationClient;
import com.sshtools.j2ssh.authentication.SshAuthenticationClient;
import com.sshtools.j2ssh.authentication.SshAuthenticationClientFactory;
import com.sshtools.j2ssh.authentication.SshAuthenticationPrompt;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.configuration.SshConnectionProperties;
import com.sshtools.j2ssh.transport.AbstractKnownHostsKeyVerification;
import com.sshtools.j2ssh.transport.HostKeyVerification;
import com.sshtools.j2ssh.transport.InvalidHostFileException;
import com.sshtools.j2ssh.transport.TransportProtocolException;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.security.AccessControlException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class SshToolsApplicationClientPanel
extends SshToolsApplicationPanel {
    public static final String PREF_CONNECTION_FILE_DIRECTORY = "sshapps.connectionFile.directory";
    public static final int BANNER_TIMEOUT = 2000;
    protected static AbstractKnownHostsKeyVerification ver;
    protected Log log = LogFactory.getLog((Class)SshToolsApplicationClientPanel.class);
    protected HostKeyVerification hostKeyVerification;
    protected File currentConnectionFile;
    protected boolean needSave;
    protected SshToolsConnectionProfile currentConnectionProfile;
    protected FileFilter connectionFileFilter = new ConnectionFileFilter();
    protected SshClient ssh;

    public SshToolsApplicationClientPanel() {
    }

    public SshToolsApplicationClientPanel(LayoutManager layoutManager) {
        super(layoutManager);
    }

    public abstract SshToolsConnectionTab[] getAdditionalConnectionTabs();

    public HostKeyVerification getHostKeyVerification() {
        return this.hostKeyVerification;
    }

    public void setHostHostVerification(HostKeyVerification hostKeyVerification) {
        this.hostKeyVerification = hostKeyVerification;
    }

    public void init(SshToolsApplication sshToolsApplication) throws SshToolsApplicationException {
        super.init(sshToolsApplication);
        try {
            ver = new DialogKnownHostsKeyVerification(this);
            this.setHostHostVerification((HostKeyVerification)ver);
            if (ver.isHostFileWriteable()) {
                sshToolsApplication.addAdditionalOptionsTab(new HostsTab(ver));
            }
        }
        catch (InvalidHostFileException invalidHostFileException) {
            this.log.warn((Object)"Host key verification will be DISABLED.", (Throwable)invalidHostFileException);
        }
    }

    public void editConnection() {
        JFileChooser jFileChooser = new JFileChooser(PreferencesStore.get(PREF_CONNECTION_FILE_DIRECTORY, System.getProperty("sshtools.home", System.getProperty("user.home"))));
        jFileChooser.setFileFilter(this.connectionFileFilter);
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            PreferencesStore.put(PREF_CONNECTION_FILE_DIRECTORY, jFileChooser.getCurrentDirectory().getAbsolutePath());
            File file = jFileChooser.getSelectedFile();
            SshToolsConnectionProfile sshToolsConnectionProfile = new SshToolsConnectionProfile();
            try {
                sshToolsConnectionProfile.open(file);
                if (this.editConnection(sshToolsConnectionProfile)) {
                    this.saveConnection(false, file, sshToolsConnectionProfile);
                }
            }
            catch (IOException iOException) {
                SshToolsApplicationClientPanel.showErrorMessage(this, "Failed to load connection profile.", "Error", iOException);
            }
        }
    }

    public SshToolsConnectionProfile newConnectionProfile(SshToolsConnectionProfile sshToolsConnectionProfile) {
        return SshToolsConnectionPanel.showConnectionDialog(this, sshToolsConnectionProfile, this.getAdditionalConnectionTabs());
    }

    public void open() {
        String string = super.getApplication().getApplicationPreferencesDirectory().getAbsolutePath();
        JFileChooser jFileChooser = new JFileChooser(string);
        jFileChooser.setFileFilter(this.connectionFileFilter);
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            PreferencesStore.put(PREF_CONNECTION_FILE_DIRECTORY, jFileChooser.getCurrentDirectory().getAbsolutePath());
            File file = jFileChooser.getSelectedFile();
            this.open(file);
        }
    }

    public void open(File file) {
        Object object;
        this.log.debug((Object)("Opening connection file " + file));
        if (this.isConnected()) {
            object = new Option("New", "New create a new window", 110);
            Option option = new Option("Close", "Close current connection", 108);
            Option option2 = new Option("Cancel", "Cancel the opening of this connection", 99);
            OptionsDialog optionsDialog = OptionsDialog.createOptionDialog(this, new Option[]{object, option, option2}, "You already have a connection open. Select\nClose to close the current connection, New\nto create a new terminal or Cancel to abort.", "Existing connection", (Option)object, null, UIManager.getIcon("OptionPane.warningIcon"));
            UIUtil.positionComponent(0, optionsDialog);
            optionsDialog.setVisible(true);
            Option option3 = optionsDialog.getSelectedOption();
            if (option3 == null || option3 == option2) {
                return;
            }
            if (option3 == object) {
                try {
                    SshToolsApplicationContainer sshToolsApplicationContainer = this.application.newContainer();
                    ((SshToolsApplicationClientPanel)sshToolsApplicationContainer.getApplicationPanel()).open(file);
                    return;
                }
                catch (SshToolsApplicationException sshToolsApplicationException) {
                    this.log.error((Object)sshToolsApplicationException);
                }
            } else {
                this.closeConnection(true);
            }
        }
        if (this.getApplication().getMRUModel() != null) {
            this.getApplication().getMRUModel().add(file);
        }
        if (file != null) {
            object = new SshToolsConnectionProfile();
            try {
                ((SshToolsConnectionProfile)((Object)object)).open(file.getAbsolutePath());
                this.setNeedSave(false);
                this.currentConnectionFile = file;
                this.setContainerTitle(file);
                this.connect((SshToolsConnectionProfile)((Object)object), false);
            }
            catch (InvalidProfileFileException invalidProfileFileException) {
                this.showExceptionMessage(invalidProfileFileException.getMessage(), "Open Connection");
            }
            catch (SshException sshException) {
                sshException.printStackTrace();
                this.showExceptionMessage("An unexpected error occured!", "Open Connection");
            }
        } else {
            this.showExceptionMessage("Invalid file specified", "Open Connection");
        }
    }

    public void connect(SshToolsConnectionProfile sshToolsConnectionProfile, final boolean bl) {
        this.ssh = new SshClient();
        this.setCurrentConnectionProfile(sshToolsConnectionProfile);
        Runnable runnable = new Runnable(){

            public void run() {
                SshToolsApplicationClientPanel.this.getStatusBar().setStatusText("Connecting");
                SshToolsApplicationClientPanel.this.getStatusBar().setHost(SshToolsApplicationClientPanel.this.getCurrentConnectionProfile().getHost(), SshToolsApplicationClientPanel.this.getCurrentConnectionProfile().getPort());
                SshToolsApplicationClientPanel.this.getStatusBar().setUser(SshToolsApplicationClientPanel.this.getCurrentConnectionProfile().getUsername());
                try {
                    SshToolsApplicationClientPanel.this.log.info((Object)("Connecting to " + SshToolsApplicationClientPanel.this.getCurrentConnectionProfile().getHost() + " as " + SshToolsApplicationClientPanel.this.getCurrentConnectionProfile().getUsername()));
                    SshToolsApplicationClientPanel.this.ssh.connect((SshConnectionProperties)SshToolsApplicationClientPanel.this.getCurrentConnectionProfile(), (HostKeyVerification)(SshToolsApplicationClientPanel.this.getHostKeyVerification() == null ? new SinkHostKeyVerification() : SshToolsApplicationClientPanel.this.getHostKeyVerification()));
                    try {
                        RemoteIdentification remoteIdentification = RemoteIdentificationFactory.getInstance(SshToolsApplicationClientPanel.this.ssh.getServerId(), SshToolsApplicationClientPanel.this.ssh.getConnectionProperties().getHost());
                        SshToolsApplicationClientPanel.this.getStatusBar().setRemoteId(remoteIdentification.getName(SshToolsApplicationClientPanel.this.ssh.getServerId()));
                    }
                    catch (RemoteIdentificationException remoteIdentificationException) {
                        SshToolsApplicationClientPanel.this.getStatusBar().setRemoteId("Unknown");
                    }
                    if (SshToolsApplicationClientPanel.this.postConnection()) {
                        if (!SshToolsApplicationClientPanel.this.authenticateUser(bl)) {
                            SshToolsApplicationClientPanel.this.closeConnection(false);
                        } else {
                            SshToolsApplicationClientPanel.this.setAvailableActions();
                        }
                    }
                }
                catch (IOException iOException) {
                    SshToolsApplicationClientPanel.this.ssh = null;
                    SshToolsApplicationClientPanel.this.showExceptionMessage("Connection Error", "Could not establish a connection to host: \n\n " + iOException.getMessage());
                    SshToolsApplicationClientPanel.this.closeConnection(false);
                }
                catch (SecurityException securityException) {
                    SshToolsApplicationClientPanel.this.ssh = null;
                    SshToolsApplicationPanel.showErrorMessage(SshToolsApplicationClientPanel.this, "Error", securityException);
                    SshToolsApplicationClientPanel.this.closeConnection(false);
                }
            }
        };
        SshThread sshThread = new SshThread(runnable, this.application.getApplicationName() + " connection", true);
        sshThread.start();
    }

    public void connect(SshClient sshClient, SshToolsConnectionProfile sshToolsConnectionProfile) throws IOException {
        this.ssh = sshClient;
        if (!sshClient.isAuthenticated()) {
            this.authenticateUser(false);
        }
        this.setCurrentConnectionProfile(sshToolsConnectionProfile);
        this.authenticationComplete(false);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean authenticateUser(boolean bl) throws IOException {
        Object object;
        SshAgentClient sshAgentClient;
        int n = 1;
        boolean bl2 = false;
        List list = SshAuthenticationClientFactory.getSupportedMethods();
        if (list.contains("publickey") && System.getProperty("sshtools.agent") != null) {
            try {
                sshAgentClient = SshAgentClient.connectLocalAgent((String)"SSHTerm", (String)System.getProperty("sshtools.agent"));
                object = new AgentAuthenticationClient();
                object.setAgent(sshAgentClient);
                object.setUsername(this.getCurrentConnectionProfile().getUsername());
                n = this.ssh.authenticate((SshAuthenticationClient)object);
                sshAgentClient.close();
            }
            catch (AgentNotAvailableException agentNotAvailableException) {
                this.log.info((Object)"No agent was available for authentication");
            }
            if (n == 4) {
                this.authenticationComplete(bl);
                return true;
            }
        }
        sshAgentClient = new ArrayList();
        object = null;
        object = this.ssh.getAvailableAuthMethods(this.getCurrentConnectionProfile().getUsername());
        final String string = this.ssh.getAuthenticationBanner(2000);
        if (string != null && !string.trim().equals("")) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        BannerDialog.showBannerDialog(SshToolsApplicationClientPanel.this, string);
                    }
                });
            }
            catch (Exception exception) {
                this.log.error((Object)"Failed to invoke and wait on BannerDialog", (Throwable)exception);
            }
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext() && !bl2) {
            Object e = iterator.next();
            if (!object.contains(e)) continue;
            sshAgentClient.add(e);
        }
        Map map = (Map)((HashMap)this.getCurrentConnectionProfile().getAuthenticationMethods()).clone();
        Iterator iterator2 = map.entrySet().iterator();
        boolean bl3 = false;
        String string2 = null;
        while (!bl3 && this.ssh.getConnectionState().getValue() != 5) {
            void var8_12;
            SshAuthenticationClient sshAuthenticationClient = null;
            if (var8_12.hasNext()) {
                Object e = var8_12.next();
                if (e instanceof Map.Entry) {
                    Map.Entry entry = (Map.Entry)e;
                    sshAuthenticationClient = (SshAuthenticationClient)entry.getValue();
                } else {
                    if (!(e instanceof String)) {
                        this.closeConnection(true);
                        throw new IOException("Iterator of Map or List of String expected");
                    }
                    sshAuthenticationClient = SshAuthenticationClientFactory.newInstance((String)((String)e));
                    sshAuthenticationClient.setUsername(this.getCurrentConnectionProfile().getUsername());
                }
            } else {
                List list2 = AuthenticationDialog.showAuthenticationDialog(this, (List)sshAgentClient, string2 == null ? "" : string2);
                if (list2.size() <= 0) {
                    this.closeConnection(true);
                    return false;
                }
                Iterator iterator3 = list2.iterator();
            }
            if (sshAuthenticationClient == null) continue;
            n = this.showAuthenticationPrompt(sshAuthenticationClient);
            if (n == 2) {
                string2 = sshAuthenticationClient.getMethodName() + " authentication failed, try again?";
            }
            if (n == 3) {
                this.getCurrentConnectionProfile().addAuthenticationMethod(sshAuthenticationClient);
                string2 = sshAuthenticationClient.getMethodName() + " authentication succeeded but another is required";
            }
            if (n == 4) {
                bl2 = true;
                this.getCurrentConnectionProfile().addAuthenticationMethod(sshAuthenticationClient);
                bl3 = true;
                this.authenticationComplete(bl);
            }
            if (n != 5) continue;
            this.ssh.disconnect();
            return false;
        }
        return bl2;
    }

    protected int showAuthenticationPrompt(SshAuthenticationClient sshAuthenticationClient) throws IOException {
        sshAuthenticationClient.setUsername(this.getCurrentConnectionProfile().getUsername());
        if (sshAuthenticationClient instanceof PasswordAuthenticationClient) {
            PasswordAuthenticationDialog passwordAuthenticationDialog = new PasswordAuthenticationDialog((Frame)SwingUtilities.getAncestorOfClass(Frame.class, this));
            sshAuthenticationClient.setAuthenticationPrompt((SshAuthenticationPrompt)passwordAuthenticationDialog);
            ((PasswordAuthenticationClient)sshAuthenticationClient).setPasswordChangePrompt((PasswordChangePrompt)PasswordChange.getInstance());
            PasswordChange.getInstance().setParentComponent(this);
        } else if (sshAuthenticationClient instanceof PublicKeyAuthenticationClient) {
            PublicKeyAuthenticationPrompt publicKeyAuthenticationPrompt = new PublicKeyAuthenticationPrompt(this);
            sshAuthenticationClient.setAuthenticationPrompt((SshAuthenticationPrompt)publicKeyAuthenticationPrompt);
        } else if (sshAuthenticationClient instanceof KBIAuthenticationClient) {
            KBIAuthenticationClient kBIAuthenticationClient = new KBIAuthenticationClient();
            ((KBIAuthenticationClient)sshAuthenticationClient).setKBIRequestHandler((KBIRequestHandler)new KBIRequestHandlerDialog((Frame)SwingUtilities.getAncestorOfClass(Frame.class, this)));
        }
        return this.ssh.authenticate(sshAuthenticationClient);
    }

    public abstract boolean postConnection();

    public abstract void authenticationComplete(boolean var1) throws SshException, IOException;

    public void setContainerTitle(File file) {
        String string = ConfigurationLoader.getVersionString((String)this.application.getApplicationName(), (String)this.application.getApplicationVersion());
        if (this.container != null) {
            this.container.setContainerTitle(file == null ? string : string + " [" + file.getName() + "]");
        }
    }

    public void setNeedSave(boolean bl) {
        if (bl != this.needSave) {
            this.needSave = bl;
            this.setAvailableActions();
        }
    }

    public void setCurrentConnectionFile(File file) {
        this.currentConnectionFile = file;
    }

    public File getCurrentConnectionFile() {
        return this.currentConnectionFile;
    }

    public void setCurrentConnectionProfile(SshToolsConnectionProfile sshToolsConnectionProfile) {
        this.currentConnectionProfile = sshToolsConnectionProfile;
    }

    public SshToolsConnectionProfile getCurrentConnectionProfile() {
        return this.currentConnectionProfile;
    }

    public boolean isNeedSave() {
        return this.needSave;
    }

    public boolean isConnected() {
        return this.ssh != null && this.ssh.isConnected();
    }

    public void connect() throws SshException {
        if (this.getCurrentConnectionProfile() == null) {
            throw new SshException("Can't connect, no connection profile have been set.");
        }
        this.connect(this.getCurrentConnectionProfile(), false);
    }

    public void closeConnection(boolean bl) {
        if (this.isNeedSave()) {
            try {
                if (System.getSecurityManager() != null) {
                    AccessController.checkPermission(new FilePermission("<<ALL FILES>>", "write"));
                    if (JOptionPane.showConfirmDialog(this, "You have unsaved changes to the connection " + (this.currentConnectionFile == null ? "<Untitled>" : this.currentConnectionFile.getName()) + ".\nDo you want to save the changes now?", "Unsaved changes", 0, 3) == 0) {
                        this.saveConnection(false, this.getCurrentConnectionFile(), this.getCurrentConnectionProfile());
                        this.setNeedSave(false);
                    }
                }
            }
            catch (AccessControlException accessControlException) {
                this.log.warn((Object)"Changes made to connection, but security manager won't allow saving of files.");
            }
        }
        this.setCurrentConnectionFile(null);
    }

    protected boolean allowConnectionSettingsEditing() {
        return true;
    }

    public boolean editConnection(SshToolsConnectionProfile sshToolsConnectionProfile) {
        final SshToolsConnectionPanel sshToolsConnectionPanel = new SshToolsConnectionPanel(this.allowConnectionSettingsEditing());
        SshToolsConnectionTab[] sshToolsConnectionTabArray = this.getAdditionalConnectionTabs();
        for (int i = 0; sshToolsConnectionTabArray != null && i < sshToolsConnectionTabArray.length; ++i) {
            sshToolsConnectionTabArray[i].setConnectionProfile(sshToolsConnectionProfile);
            sshToolsConnectionPanel.addTab(sshToolsConnectionTabArray[i]);
        }
        sshToolsConnectionPanel.setConnectionProfile(sshToolsConnectionProfile);
        final Option option = new Option("Ok", "Apply the settings and close this dialog", 111);
        Option option2 = new Option("Cancel", "Close this dialog without applying the settings", 99);
        OptionCallback optionCallback = new OptionCallback(){

            public boolean canClose(OptionsDialog optionsDialog, Option option2) {
                if (option2 == option) {
                    return sshToolsConnectionPanel.validateTabs();
                }
                return true;
            }
        };
        OptionsDialog optionsDialog = OptionsDialog.createOptionDialog(this, new Option[]{option, option2}, sshToolsConnectionPanel, "Connection Settings", option, optionCallback, null);
        optionsDialog.pack();
        UIUtil.positionComponent(0, optionsDialog);
        optionsDialog.setVisible(true);
        if (optionsDialog.getSelectedOption() == option) {
            sshToolsConnectionPanel.applyTabs();
            if (sshToolsConnectionProfile == this.getCurrentConnectionProfile()) {
                this.setNeedSave(true);
            }
            return true;
        }
        return false;
    }

    public File saveConnection(boolean bl, File file, SshToolsConnectionProfile sshToolsConnectionProfile) {
        if (sshToolsConnectionProfile != null) {
            if (file == null || bl) {
                String string = super.getApplication().getApplicationPreferencesDirectory().getAbsolutePath();
                JFileChooser jFileChooser = new JFileChooser(string);
                jFileChooser.setFileFilter(this.connectionFileFilter);
                int n = jFileChooser.showSaveDialog(this);
                if (n == 1) {
                    return null;
                }
                file = jFileChooser.getSelectedFile();
                if (!file.getName().toLowerCase().endsWith(".xml")) {
                    file = new File(file.getAbsolutePath() + ".xml");
                }
            }
            try {
                if (bl && file.exists() && JOptionPane.showConfirmDialog(this, "File already exists. Are you sure?", "File exists", 0, 2) == 1) {
                    return null;
                }
                if (file != null) {
                    this.log.debug((Object)("Saving connection to " + file.getAbsolutePath()));
                    sshToolsConnectionProfile.save(file.getAbsolutePath());
                    if (sshToolsConnectionProfile == this.getCurrentConnectionProfile()) {
                        this.log.debug((Object)"Current connection saved, disabling save action.");
                        this.setNeedSave(false);
                    }
                    return file;
                }
                this.showExceptionMessage("The file specified is invalid!", "Save Connection");
            }
            catch (InvalidProfileFileException invalidProfileFileException) {
                this.showExceptionMessage(invalidProfileFileException.getMessage(), "Save Connection");
            }
        }
        return null;
    }

    class SinkHostKeyVerification
    implements HostKeyVerification {
        SinkHostKeyVerification() {
        }

        public boolean verifyHost(String string, SshPublicKey sshPublicKey) throws TransportProtocolException {
            SshToolsApplicationClientPanel.this.log.warn((Object)("Accepting host " + string + " as host key verification is disabled."));
            return true;
        }
    }

    class ConnectionFileFilter
    extends FileFilter {
        ConnectionFileFilter() {
        }

        public boolean accept(File file) {
            return file.isDirectory() || file.getName().toLowerCase().endsWith(".xml");
        }

        public String getDescription() {
            return "Connection files (*.xml)";
        }
    }

    class MenuItemActionComparator
    implements Comparator {
        MenuItemActionComparator() {
        }

        public int compare(Object object, Object object2) {
            int n = ((Integer)((StandardAction)object).getValue("menuItemGroup")).compareTo((Integer)((StandardAction)object2).getValue("menuItemGroup"));
            return n == 0 ? ((Integer)((StandardAction)object).getValue("menuItemWeight")).compareTo((Integer)((StandardAction)object2).getValue("menuItemWeight")) : n;
        }
    }

    class ToolBarActionComparator
    implements Comparator {
        ToolBarActionComparator() {
        }

        public int compare(Object object, Object object2) {
            int n = ((Integer)((StandardAction)object).getValue("toolBarGroup")).compareTo((Integer)((StandardAction)object2).getValue("toolBarGroup"));
            return n == 0 ? ((Integer)((StandardAction)object).getValue("toolBarWeight")).compareTo((Integer)((StandardAction)object2).getValue("toolBarWeight")) : n;
        }
    }

    public static class ActionMenu
    implements Comparable {
        int weight;
        int mnemonic;
        String name;
        String displayName;

        public ActionMenu(String string, String string2, int n, int n2) {
            this.name = string;
            this.displayName = string2;
            this.mnemonic = n;
            this.weight = n2;
        }

        public int compareTo(Object object) {
            int n = new Integer(this.weight).compareTo(new Integer(((ActionMenu)object).weight));
            return n == 0 ? this.displayName.compareTo(((ActionMenu)object).displayName) : n;
        }
    }
}

