/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ui;

import com.sshtools.common.configuration.SshToolsConnectionProfile;
import com.sshtools.common.ui.IconWrapperPanel;
import com.sshtools.common.ui.ResourceIcon;
import com.sshtools.common.ui.SshToolsConnectionTab;
import com.sshtools.common.ui.UIUtil;
import com.sshtools.j2ssh.transport.cipher.SshCipherFactory;
import com.sshtools.j2ssh.transport.compression.SshCompressionFactory;
import com.sshtools.j2ssh.transport.hmac.SshHmacFactory;
import com.sshtools.j2ssh.transport.kex.SshKeyExchangeFactory;
import com.sshtools.j2ssh.transport.publickey.SshKeyPairFactory;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class SshToolsConnectionProtocolTab
extends JPanel
implements SshToolsConnectionTab {
    static final String KEYS_ICON = "/com/sshtools/common/ui/largekeys.png";
    static final String PROTOCOL_ICON = "/com/sshtools/common/ui/largeprotocol.png";
    static final String DEFAULT = "<Default>";
    protected JComboBox jComboCipherCS = new JComboBox();
    protected JComboBox jComboCipherSC = new JComboBox();
    protected JComboBox jComboMacCS = new JComboBox();
    protected JComboBox jComboMacSC = new JComboBox();
    protected JComboBox jComboCompCS = new JComboBox();
    protected JComboBox jComboCompSC = new JComboBox();
    protected JComboBox jComboKex = new JComboBox();
    protected JComboBox jComboPK = new JComboBox();
    protected SshToolsConnectionProfile profile;

    public SshToolsConnectionProtocolTab() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.weightx = 1.0;
        UIUtil.jGridBagAdd(jPanel, new JLabel("Public key"), gridBagConstraints, 0);
        gridBagConstraints.fill = 2;
        UIUtil.jGridBagAdd(jPanel, this.jComboPK, gridBagConstraints, 0);
        gridBagConstraints.fill = 0;
        UIUtil.jGridBagAdd(jPanel, new JLabel("Key exchange"), gridBagConstraints, 0);
        gridBagConstraints.fill = 2;
        UIUtil.jGridBagAdd(jPanel, this.jComboKex, gridBagConstraints, 0);
        gridBagConstraints.fill = 0;
        IconWrapperPanel iconWrapperPanel = new IconWrapperPanel(new ResourceIcon(KEYS_ICON), jPanel);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        UIUtil.jGridBagAdd(jPanel2, new JLabel("Client - > Server"), gridBagConstraints, -1);
        UIUtil.jGridBagAdd(jPanel2, new JLabel("Server - > Client"), gridBagConstraints, 0);
        gridBagConstraints.weightx = 2.0;
        UIUtil.jGridBagAdd(jPanel2, new JSeparator(0), gridBagConstraints, 0);
        UIUtil.jGridBagAdd(jPanel2, new JLabel("Cipher"), gridBagConstraints, -1);
        UIUtil.jGridBagAdd(jPanel2, new JLabel("Cipher"), gridBagConstraints, 0);
        UIUtil.jGridBagAdd(jPanel2, this.jComboCipherCS, gridBagConstraints, -1);
        UIUtil.jGridBagAdd(jPanel2, this.jComboCipherSC, gridBagConstraints, 0);
        UIUtil.jGridBagAdd(jPanel2, new JLabel("Mac"), gridBagConstraints, -1);
        UIUtil.jGridBagAdd(jPanel2, new JLabel("Mac"), gridBagConstraints, 0);
        UIUtil.jGridBagAdd(jPanel2, this.jComboMacCS, gridBagConstraints, -1);
        UIUtil.jGridBagAdd(jPanel2, this.jComboMacSC, gridBagConstraints, 0);
        UIUtil.jGridBagAdd(jPanel2, new JLabel("Compression"), gridBagConstraints, -1);
        UIUtil.jGridBagAdd(jPanel2, new JLabel("Compression"), gridBagConstraints, 0);
        UIUtil.jGridBagAdd(jPanel2, this.jComboCompCS, gridBagConstraints, -1);
        UIUtil.jGridBagAdd(jPanel2, this.jComboCompSC, gridBagConstraints, 0);
        IconWrapperPanel iconWrapperPanel2 = new IconWrapperPanel(new ResourceIcon(PROTOCOL_ICON), jPanel2);
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.weightx = 1.0;
        UIUtil.jGridBagAdd(this, iconWrapperPanel, gridBagConstraints, 0);
        gridBagConstraints.weighty = 1.0;
        UIUtil.jGridBagAdd(this, iconWrapperPanel2, gridBagConstraints, 0);
        this.loadList(SshCipherFactory.getSupportedCiphers(), this.jComboCipherCS, true);
        this.loadList(SshCipherFactory.getSupportedCiphers(), this.jComboCipherSC, true);
        this.loadList(SshHmacFactory.getSupportedMacs(), this.jComboMacCS, true);
        this.loadList(SshHmacFactory.getSupportedMacs(), this.jComboMacSC, true);
        this.loadList(SshCompressionFactory.getSupportedCompression(), this.jComboCompCS, true);
        this.loadList(SshCompressionFactory.getSupportedCompression(), this.jComboCompSC, true);
        this.loadList(SshKeyExchangeFactory.getSupportedKeyExchanges(), this.jComboKex, true);
        this.loadList(SshKeyPairFactory.getSupportedKeys(), this.jComboPK, true);
    }

    public void setConnectionProfile(SshToolsConnectionProfile sshToolsConnectionProfile) {
        this.profile = sshToolsConnectionProfile;
        this.jComboCipherCS.setSelectedItem(sshToolsConnectionProfile.getPrefCSEncryption());
        this.jComboCipherSC.setSelectedItem(sshToolsConnectionProfile.getPrefSCEncryption());
        this.jComboMacCS.setSelectedItem(sshToolsConnectionProfile.getPrefCSMac());
        this.jComboMacSC.setSelectedItem(sshToolsConnectionProfile.getPrefSCMac());
        this.jComboCompCS.setSelectedItem(sshToolsConnectionProfile.getPrefCSComp());
        this.jComboCompSC.setSelectedItem(sshToolsConnectionProfile.getPrefSCComp());
        this.jComboKex.setSelectedItem(sshToolsConnectionProfile.getPrefKex());
        this.jComboPK.setSelectedItem(sshToolsConnectionProfile.getPrefPublicKey());
    }

    public SshToolsConnectionProfile getConnectionProfile() {
        return this.profile;
    }

    private void loadList(List list, JComboBox jComboBox, boolean bl) {
        Iterator iterator = list.iterator();
        if (bl) {
            jComboBox.addItem(DEFAULT);
        }
        while (iterator.hasNext()) {
            jComboBox.addItem(iterator.next());
        }
    }

    public String getTabContext() {
        return "Connection";
    }

    public Icon getTabIcon() {
        return null;
    }

    public String getTabTitle() {
        return "Protocol";
    }

    public String getTabToolTipText() {
        return "Protocol related properties.";
    }

    public int getTabMnemonic() {
        return 112;
    }

    public Component getTabComponent() {
        return this;
    }

    public boolean validateTab() {
        return true;
    }

    public void applyTab() {
        if (!this.jComboCipherCS.getSelectedItem().equals(DEFAULT)) {
            this.profile.setPrefCSEncryption((String)this.jComboCipherCS.getSelectedItem());
        }
        if (!this.jComboCipherSC.getSelectedItem().equals(DEFAULT)) {
            this.profile.setPrefSCEncryption((String)this.jComboCipherSC.getSelectedItem());
        }
        if (!this.jComboMacCS.getSelectedItem().equals(DEFAULT)) {
            this.profile.setPrefCSMac((String)this.jComboMacCS.getSelectedItem());
        }
        if (!this.jComboMacSC.getSelectedItem().equals(DEFAULT)) {
            this.profile.setPrefSCMac((String)this.jComboMacSC.getSelectedItem());
        }
        if (!this.jComboCompCS.getSelectedItem().equals(DEFAULT)) {
            this.profile.setPrefCSComp((String)this.jComboCompCS.getSelectedItem());
        }
        if (!this.jComboCompSC.getSelectedItem().equals(DEFAULT)) {
            this.profile.setPrefSCComp((String)this.jComboCompSC.getSelectedItem());
        }
        if (!this.jComboKex.getSelectedItem().equals(DEFAULT)) {
            this.profile.setPrefKex((String)this.jComboKex.getSelectedItem());
        }
        if (!this.jComboPK.getSelectedItem().equals(DEFAULT)) {
            this.profile.setPrefPublicKey((String)this.jComboPK.getSelectedItem());
        }
    }

    public void tabSelected() {
    }
}

