/*
 * Decompiled with CFR 0.152.
 */
package cz.cesnet.cloud.occi.api;

import cz.cesnet.cloud.occi.Model;
import cz.cesnet.cloud.occi.api.exception.EntityBuildingException;
import cz.cesnet.cloud.occi.core.Action;
import cz.cesnet.cloud.occi.core.ActionInstance;
import cz.cesnet.cloud.occi.core.Kind;
import cz.cesnet.cloud.occi.core.Link;
import cz.cesnet.cloud.occi.core.Mixin;
import cz.cesnet.cloud.occi.core.Resource;
import cz.cesnet.cloud.occi.exception.AmbiguousIdentifierException;
import cz.cesnet.cloud.occi.exception.InvalidAttributeValueException;
import cz.cesnet.cloud.occi.infrastructure.Compute;
import cz.cesnet.cloud.occi.infrastructure.IPNetwork;
import cz.cesnet.cloud.occi.infrastructure.IPNetworkInterface;
import cz.cesnet.cloud.occi.infrastructure.Network;
import cz.cesnet.cloud.occi.infrastructure.NetworkInterface;
import cz.cesnet.cloud.occi.infrastructure.Storage;
import cz.cesnet.cloud.occi.infrastructure.StorageLink;
import java.net.URI;
import java.util.UUID;

public class EntityBuilder {
    private Model model;

    public EntityBuilder(Model model) {
        if (model == null) {
            throw new NullPointerException("model cannot be null");
        }
        this.model = model;
    }

    private Kind getKind(String type) throws EntityBuildingException, AmbiguousIdentifierException {
        Kind kind = this.model.findKind(type);
        if (kind == null) {
            throw new EntityBuildingException("unknown type '" + type + "'");
        }
        return kind;
    }

    private Kind getKind(URI identifier) throws EntityBuildingException {
        Kind kind = this.model.findKind(identifier);
        if (kind == null) {
            throw new EntityBuildingException("unknown identifier '" + identifier + "'");
        }
        return kind;
    }

    private Kind getKind(Class resourceClass) throws EntityBuildingException {
        Kind kind;
        URI uri = null;
        Kind defaultKind = null;
        if (resourceClass.equals(Compute.class)) {
            uri = URI.create(Compute.KIND_IDENTIFIER_DEFAULT);
            defaultKind = Compute.getDefaultKind();
        } else if (resourceClass.equals(Network.class)) {
            uri = URI.create(Network.KIND_IDENTIFIER_DEFAULT);
            defaultKind = Network.getDefaultKind();
        } else if (resourceClass.equals(Storage.class)) {
            uri = URI.create(Storage.KIND_IDENTIFIER_DEFAULT);
            defaultKind = Storage.getDefaultKind();
        } else if (resourceClass.equals(StorageLink.class)) {
            uri = URI.create(StorageLink.KIND_IDENTIFIER_DEFAULT);
            defaultKind = StorageLink.getDefaultKind();
        } else if (resourceClass.equals(NetworkInterface.class)) {
            uri = URI.create(NetworkInterface.KIND_IDENTIFIER_DEFAULT);
            defaultKind = NetworkInterface.getDefaultKind();
        } else {
            throw new EntityBuildingException("unknown class '" + resourceClass.getName() + "'");
        }
        try {
            kind = this.getKind(uri);
        }
        catch (EntityBuildingException ex) {
            kind = defaultKind;
        }
        return kind;
    }

    private Mixin getMixin(URI identifier) throws EntityBuildingException {
        Mixin mixin = this.model.findMixin(identifier);
        if (mixin == null) {
            throw new EntityBuildingException("unknown identifier '" + identifier + "'");
        }
        return mixin;
    }

    private Action getAction(String type) throws EntityBuildingException, AmbiguousIdentifierException {
        Action action = this.model.findAction(type);
        if (action == null) {
            throw new EntityBuildingException("unknown type '" + type + "'");
        }
        return action;
    }

    private Action getAction(URI identifier) throws EntityBuildingException {
        Action action = this.model.findAction(identifier);
        if (action == null) {
            throw new EntityBuildingException("unknown identifier '" + identifier + "'");
        }
        return action;
    }

    public Link getLink(String linkType) throws EntityBuildingException {
        try {
            Kind kind = this.getKind(linkType);
            return this.createLink(kind);
        }
        catch (AmbiguousIdentifierException ex) {
            throw new EntityBuildingException(ex);
        }
    }

    public Link getLink(URI linkIdentifier) throws EntityBuildingException {
        return this.createLink(this.getKind(linkIdentifier));
    }

    public Resource getResource(String resourceType) throws EntityBuildingException {
        try {
            Kind kind = this.getKind(resourceType);
            return this.createResource(kind);
        }
        catch (AmbiguousIdentifierException ex) {
            throw new EntityBuildingException(ex);
        }
    }

    public Resource getResource(URI resourceIdentifier) throws EntityBuildingException {
        return this.createResource(this.getKind(resourceIdentifier));
    }

    public ActionInstance getActionInstance(String actionType) throws EntityBuildingException {
        try {
            Action action = this.getAction(actionType);
            return this.createActionInstance(action);
        }
        catch (AmbiguousIdentifierException ex) {
            throw new EntityBuildingException(ex);
        }
    }

    public ActionInstance getActionInstance(URI actionIdentifier) throws EntityBuildingException {
        return this.createActionInstance(this.getAction(actionIdentifier));
    }

    public Compute getCompute(URI resourceIdentifier) throws EntityBuildingException {
        return this.createCompute(this.getKind(resourceIdentifier));
    }

    public Compute getCompute() throws EntityBuildingException {
        return this.createCompute(this.getKind(Compute.class));
    }

    public Network getNetwork(URI resourceIdentifier) throws EntityBuildingException {
        return this.createNetwork(this.getKind(resourceIdentifier));
    }

    public Network getNetwork() throws EntityBuildingException {
        return this.createNetwork(this.getKind(Network.class));
    }

    public Storage getStorage(URI resourceIdentifier) throws EntityBuildingException {
        return this.createStorage(this.getKind(resourceIdentifier));
    }

    public Storage getStorage() throws EntityBuildingException {
        return this.createStorage(this.getKind(Storage.class));
    }

    public StorageLink getStorageLink(URI resourceIdentifier) throws EntityBuildingException {
        return this.createStorageLink(this.getKind(resourceIdentifier));
    }

    public StorageLink getStorageLink() throws EntityBuildingException {
        return this.createStorageLink(this.getKind(StorageLink.class));
    }

    public NetworkInterface getNetworkInterface(URI resourceIdentifier) throws EntityBuildingException {
        return this.createNetworkInterface(this.getKind(resourceIdentifier));
    }

    public NetworkInterface getNetworkInterface() throws EntityBuildingException {
        return this.createNetworkInterface(this.getKind(NetworkInterface.class));
    }

    public IPNetwork getIPNetwork(URI kindIdentifier, URI mixinIdentifier) throws EntityBuildingException {
        return this.createIPNetwork(this.getKind(kindIdentifier), this.getMixin(mixinIdentifier));
    }

    public IPNetwork getIPNetwork() throws EntityBuildingException {
        Mixin mixin;
        Kind kind = this.getKind(Network.class);
        try {
            mixin = this.getMixin(URI.create(IPNetwork.MIXIN_IDENTIFIER_DEFAULT));
        }
        catch (EntityBuildingException ex) {
            mixin = IPNetwork.getDefaultMixin();
        }
        return this.createIPNetwork(kind, mixin);
    }

    public IPNetworkInterface getIPNetworkInterface(URI kindIdentifier, URI mixinIdentifier) throws EntityBuildingException {
        return this.createIPNetworkInterface(this.getKind(kindIdentifier), this.getMixin(mixinIdentifier));
    }

    public IPNetworkInterface getIPNetworkInterface() throws EntityBuildingException {
        Mixin mixin;
        Kind kind = this.getKind(NetworkInterface.class);
        try {
            mixin = this.getMixin(URI.create(IPNetworkInterface.MIXIN_IDENTIFIER_DEFAULT));
        }
        catch (EntityBuildingException ex) {
            mixin = IPNetworkInterface.getDefaultMixin();
        }
        return this.createIPNetworkInterface(kind, mixin);
    }

    private Resource createResource(Kind kind) {
        try {
            Resource resource = new Resource(UUID.randomUUID().toString(), kind);
            resource.setModel(this.model);
            return resource;
        }
        catch (InvalidAttributeValueException ex) {
            throw new RuntimeException("Invalid ID attribute value. This should not happen!", ex);
        }
    }

    private Link createLink(Kind kind) {
        try {
            Link link = new Link(UUID.randomUUID().toString(), kind);
            link.setModel(this.model);
            return link;
        }
        catch (InvalidAttributeValueException ex) {
            throw new RuntimeException("Invalid ID attribute value. This should not happen!", ex);
        }
    }

    private ActionInstance createActionInstance(Action action) {
        ActionInstance ai = new ActionInstance(action);
        ai.setModel(this.model);
        return ai;
    }

    private Compute createCompute(Kind kind) {
        try {
            Compute compute = new Compute(UUID.randomUUID().toString(), kind);
            compute.setModel(this.model);
            return compute;
        }
        catch (InvalidAttributeValueException ex) {
            throw new RuntimeException("Invalid ID attribute value. This should not happen!", ex);
        }
    }

    private Network createNetwork(Kind kind) {
        try {
            Network network = new Network(UUID.randomUUID().toString(), kind);
            network.setModel(this.model);
            return network;
        }
        catch (InvalidAttributeValueException ex) {
            throw new RuntimeException("Invalid ID attribute value. This should not happen!", ex);
        }
    }

    private Storage createStorage(Kind kind) {
        try {
            Storage storage = new Storage(UUID.randomUUID().toString(), kind);
            storage.setModel(this.model);
            return storage;
        }
        catch (InvalidAttributeValueException ex) {
            throw new RuntimeException("Invalid ID attribute value. This should not happen!", ex);
        }
    }

    private StorageLink createStorageLink(Kind kind) {
        try {
            StorageLink storageLink = new StorageLink(UUID.randomUUID().toString(), kind);
            storageLink.setModel(this.model);
            return storageLink;
        }
        catch (InvalidAttributeValueException ex) {
            throw new RuntimeException("Invalid ID attribute value. This should not happen!", ex);
        }
    }

    private NetworkInterface createNetworkInterface(Kind kind) {
        try {
            NetworkInterface networkInterface = new NetworkInterface(UUID.randomUUID().toString(), kind);
            networkInterface.setModel(this.model);
            return networkInterface;
        }
        catch (InvalidAttributeValueException ex) {
            throw new RuntimeException("Invalid ID attribute value. This should not happen!", ex);
        }
    }

    private IPNetwork createIPNetwork(Kind kind, Mixin mixin) {
        try {
            IPNetwork ipnetwork = new IPNetwork(UUID.randomUUID().toString(), kind);
            ipnetwork.setModel(this.model);
            ipnetwork.addMixin(mixin);
            return ipnetwork;
        }
        catch (InvalidAttributeValueException ex) {
            throw new RuntimeException("Invalid ID attribute value. This should not happen!", ex);
        }
    }

    private IPNetworkInterface createIPNetworkInterface(Kind kind, Mixin mixin) {
        try {
            IPNetworkInterface ipnetworkInterface = new IPNetworkInterface(UUID.randomUUID().toString(), kind);
            ipnetworkInterface.setModel(this.model);
            ipnetworkInterface.addMixin(mixin);
            return ipnetworkInterface;
        }
        catch (InvalidAttributeValueException ex) {
            throw new RuntimeException("Invalid ID attribute value. This should not happen!", ex);
        }
    }

    public Model getModel() {
        return this.model;
    }

    public void setModel(Model model) {
        this.model = model;
    }
}

