/*
 * Decompiled with CFR 0.152.
 */
package cz.cesnet.cloud.occi.api.http.auth;

import com.owlike.genson.stream.JsonReader;
import com.owlike.genson.stream.JsonWriter;
import cz.cesnet.cloud.occi.api.Authentication;
import cz.cesnet.cloud.occi.api.exception.AuthenticationException;
import cz.cesnet.cloud.occi.api.exception.CommunicationException;
import cz.cesnet.cloud.occi.api.http.HTTPConnection;
import cz.cesnet.cloud.occi.api.http.HTTPHelper;
import cz.cesnet.cloud.occi.api.http.auth.BasicAuthentication;
import cz.cesnet.cloud.occi.api.http.auth.HTTPAuthentication;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeystoneAuthentication
extends HTTPAuthentication {
    private static final Logger LOGGER = LoggerFactory.getLogger(KeystoneAuthentication.class);
    public static final String IDENTIFIER = "OCCIKeystoneAuthentication";
    private static final String HEADER_AUTH = "Www-Authenticate";
    private static final String HEADER_X_AUTH_TOKEN = "X-Auth-Token";
    private static final String GROUP_URI = "uri";
    private static final String REGEXP_KEYSTONE_URI = "^(?:Keystone|snf-auth) uri='(?<uri>.+)'$";
    private static final Pattern PATTERN_KEYSTONE_URI = Pattern.compile("^(?:Keystone|snf-auth) uri='(?<uri>.+)'$");
    private static final String PATH_DEFAULT = "/v2.0";
    private final HTTPAuthentication originalAuthentication;
    private CloseableHttpResponse originalResponse = null;
    private String authToken = null;

    public KeystoneAuthentication(HTTPAuthentication originalAuthentication) {
        this.originalAuthentication = originalAuthentication;
    }

    public CloseableHttpResponse getOriginalResponse() {
        return this.originalResponse;
    }

    public void setOriginalResponse(CloseableHttpResponse response) {
        this.originalResponse = response;
    }

    @Override
    public String getIdentifier() {
        return IDENTIFIER;
    }

    @Override
    public Authentication getFallback() {
        return null;
    }

    private void checkResponse() throws AuthenticationException {
        if (this.originalResponse == null) {
            throw new AuthenticationException("no response to react to");
        }
        if (!this.originalResponse.containsHeader(HEADER_AUTH)) {
            throw new AuthenticationException("missing 'Www-Authenticate' header");
        }
    }

    @Override
    public void authenticate() throws CommunicationException {
        this.checkResponse();
        Matcher matcher = PATTERN_KEYSTONE_URI.matcher(this.originalResponse.getFirstHeader(HEADER_AUTH).getValue());
        if (!matcher.find()) {
            throw new AuthenticationException("incorrect Www-Authenticate content");
        }
        URI keystoneURI = URI.create(matcher.group(GROUP_URI));
        HttpHost target = new HttpHost(keystoneURI.getHost(), keystoneURI.getPort(), keystoneURI.getScheme());
        String path = keystoneURI.getPath();
        if (path == null) {
            path = "";
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (!path.endsWith(PATH_DEFAULT)) {
            path = path + PATH_DEFAULT;
        }
        HTTPConnection connection = this.originalAuthentication.getConnection();
        CloseableHttpClient client = connection.getClient();
        HttpContext context = connection.getContext();
        String response = this.authenticateAgainstKeystone(target, path, client, context, null);
        this.authToken = this.parseId(response);
        response = this.getTenants(target, path, client, context);
        this.tryTenants(response, target, path, client, context);
        LOGGER.debug("Scoped token: " + this.authToken);
        connection.addHeader((Header)new BasicHeader(HEADER_X_AUTH_TOKEN, this.authToken));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String authenticateAgainstKeystone(HttpHost target, String path, CloseableHttpClient client, HttpContext context, String tenant) throws CommunicationException {
        try {
            HttpPost httpPost = HTTPHelper.preparePost(path + "/tokens", this.getHeaders());
            httpPost.setEntity((HttpEntity)new StringEntity(this.getRequestBody(tenant)));
            try (CloseableHttpResponse response = HTTPHelper.runRequest((HttpRequest)httpPost, target, client, context);){
                String string = EntityUtils.toString((HttpEntity)response.getEntity());
                return string;
            }
        }
        catch (IOException ex) {
            throw new CommunicationException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getTenants(HttpHost target, String path, CloseableHttpClient client, HttpContext context) throws CommunicationException {
        try {
            HttpGet httpGet = HTTPHelper.prepareGet(path + "/tenants", this.getHeaders());
            try (CloseableHttpResponse response = HTTPHelper.runRequest((HttpRequest)httpGet, target, client, context);){
                String string = EntityUtils.toString((HttpEntity)response.getEntity());
                return string;
            }
        }
        catch (IOException ex) {
            throw new CommunicationException(ex);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void tryTenants(String json, HttpHost target, String path, CloseableHttpClient client, HttpContext context) throws AuthenticationException {
        block24: {
            reader = new JsonReader(json);
            var7_7 = null;
            try {
                block23: {
                    reader.beginObject();
                    while (reader.hasNext() != false) {
                        reader.next();
                        if (!reader.name().equals("tenants")) {
                            reader.skipValue();
                            continue;
                        }
                        break block23;
                    }
                    return;
                }
                reader.beginArray();
            }
            catch (Throwable var8_10) {
                var7_7 = var8_10;
                throw var8_10;
            }
lbl22:
            // 2 sources

            while (true) {
                if (reader.hasNext()) {
                    reader.next();
                    reader.beginObject();
                    break block24;
                }
                reader.endArray();
                throw new AuthenticationException("no suitable tenant found");
            }
            finally {
                if (reader != null) {
                    if (var7_7 != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable x2) {
                            var7_7.addSuppressed(x2);
                        }
                    } else {
                        reader.close();
                    }
                }
            }
        }
        while (reader.hasNext()) {
            reader.next();
            if (!reader.name().equals("name")) {
                reader.skipValue();
                continue;
            }
            tenant = reader.valueAsString();
            try {
                response = this.authenticateAgainstKeystone(target, path, client, context, tenant);
                this.authToken = this.parseId(response);
                return;
            }
            catch (CommunicationException var9_11) {
            }
        }
        reader.endObject();
        ** while (true)
    }

    private String getRequestBody(String tenant) throws AuthenticationException {
        String identifier;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        JsonWriter writer = new JsonWriter((Writer)new OutputStreamWriter(out));
        writer.beginObject();
        writer.writeName("auth");
        writer.beginObject();
        switch (identifier = this.originalAuthentication.getIdentifier()) {
            case "OCCIVOMSAuthentication": {
                writer.writeBoolean("voms", Boolean.valueOf(true));
                break;
            }
            case "OCCIBasicAuthentication": 
            case "OCCIDigestAuthentication": {
                BasicAuthentication ba = (BasicAuthentication)this.originalAuthentication;
                writer.writeName("passwordCredentials");
                writer.beginObject();
                writer.writeString("username", ba.getUsername());
                writer.writeString("password", ba.getPassword());
                writer.endObject();
                break;
            }
            default: {
                throw new AuthenticationException("unknown original authentication method");
            }
        }
        if (tenant != null) {
            writer.writeString("tenantName", tenant);
        }
        writer.endObject();
        writer.endObject();
        writer.close();
        return out.toString();
    }

    private String parseId(String json) {
        try (JsonReader reader = new JsonReader(json);){
            String id = null;
            reader.beginObject();
            while (reader.hasNext()) {
                reader.next();
                if (!reader.name().equals("access")) {
                    reader.skipValue();
                    continue;
                }
                reader.beginObject();
                while (reader.hasNext()) {
                    reader.next();
                    if (!reader.name().equals("token")) {
                        reader.skipValue();
                        continue;
                    }
                    reader.beginObject();
                    while (reader.hasNext()) {
                        reader.next();
                        if (!reader.name().equals("id")) {
                            reader.skipValue();
                            continue;
                        }
                        id = reader.valueAsString();
                        break;
                    }
                    break block9;
                    break;
                }
                break;
            }
            String string = id;
            return string;
        }
    }

    private Header[] getHeaders() {
        Header[] headers;
        if (this.authToken != null) {
            headers = new Header[3];
            headers[2] = new BasicHeader(HEADER_X_AUTH_TOKEN, this.authToken);
        } else {
            headers = new Header[]{new BasicHeader("Content-Type", "application/json"), new BasicHeader("Accept", "application/json")};
        }
        return headers;
    }
}

