/*
 * Decompiled with CFR 0.152.
 */
package cz.cesnet.cloud.occi.api.http.auth;

import cz.cesnet.cloud.occi.api.Authentication;
import cz.cesnet.cloud.occi.api.http.auth.CertificateAuthentication;
import cz.cesnet.cloud.occi.api.http.auth.KeystoneAuthentication;

public class X509Authentication
extends CertificateAuthentication {
    public static final String IDENTIFIER = "OCCIX509Authentication";

    public X509Authentication(String certificate, String password) {
        if (password.isEmpty()) {
            throw new IllegalArgumentException("password cannot be empty");
        }
        this.setCertificate(certificate);
        super.setPassword(password);
    }

    @Override
    public String getIdentifier() {
        return IDENTIFIER;
    }

    @Override
    public Authentication getFallback() {
        return new KeystoneAuthentication(this);
    }

    @Override
    public void setPassword(String password) {
        if (password.isEmpty()) {
            throw new IllegalArgumentException("password cannot be empty");
        }
        super.setPassword(password);
    }
}

