/*
 * Decompiled with CFR 0.152.
 */
package cz.cesnet.cloud.occi.core;

import com.sun.net.httpserver.Headers;
import cz.cesnet.cloud.occi.Model;
import cz.cesnet.cloud.occi.collection.SetCover;
import cz.cesnet.cloud.occi.core.Action;
import cz.cesnet.cloud.occi.core.Attribute;
import cz.cesnet.cloud.occi.core.Category;
import cz.cesnet.cloud.occi.core.Entity;
import cz.cesnet.cloud.occi.core.Kind;
import cz.cesnet.cloud.occi.core.Link;
import cz.cesnet.cloud.occi.core.Mixin;
import cz.cesnet.cloud.occi.exception.InvalidAttributeValueException;
import cz.cesnet.cloud.occi.exception.RenderingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Resource
extends Entity {
    public static final String SUMMARY_ATTRIBUTE_NAME = "occi.core.summary";
    public static final URI SCHEME_DEFAULT = Category.SCHEME_CORE_DEFAULT;
    public static final String TERM_DEFAULT = "resource";
    public static final String KIND_IDENTIFIER_DEFAULT = SCHEME_DEFAULT + "resource";
    private static final Logger LOGGER = LoggerFactory.getLogger(Resource.class);
    private final SetCover<Link> links = new SetCover();
    private final SetCover<Action> actions = new SetCover();

    public Resource(String id, Kind kind, String title, Model model, String summary) throws InvalidAttributeValueException {
        super(id, kind, title, model);
        this.addAttribute(SUMMARY_ATTRIBUTE_NAME, summary);
    }

    public Resource(String id, Kind kind) throws InvalidAttributeValueException {
        super(id, kind);
    }

    public String getSummary() {
        return this.getValue(SUMMARY_ATTRIBUTE_NAME);
    }

    public void setSummary(String summary) throws InvalidAttributeValueException {
        this.addAttribute(SUMMARY_ATTRIBUTE_NAME, summary);
    }

    public boolean containsLink(Link link) {
        return this.links.contains(link);
    }

    public boolean containsLink(String term) {
        for (Link link : this.links.getSet()) {
            if (!link.getKind().getTerm().equals(term)) continue;
            return true;
        }
        return false;
    }

    public boolean containsLink(URI identifier) {
        String identifierString = identifier.toString();
        for (Link link : this.links.getSet()) {
            if (!link.getKind().getIdentifier().equals(identifierString)) continue;
            return true;
        }
        return false;
    }

    public boolean addLink(Link link) {
        if (link.getSource() == null) {
            try {
                link.setSource(this);
            }
            catch (InvalidAttributeValueException ex) {
                LOGGER.error("This should not be happening!");
            }
        }
        return this.links.add(link);
    }

    public boolean addLinks(Collection<Link> links) {
        for (Link link : links) {
            if (link.getSource() != null) continue;
            try {
                link.setSource(this);
            }
            catch (InvalidAttributeValueException ex) {
                LOGGER.error("This should not be happening!");
            }
        }
        return this.links.addAll(links);
    }

    public Set<Link> getLinks(String term) {
        HashSet<Link> set = new HashSet<Link>();
        for (Link link : this.links.getSet()) {
            if (!link.getKind().getTerm().equals(term)) continue;
            set.add(link);
        }
        return set;
    }

    public Set<Link> getLinks(URI identifier) {
        String identifierString = identifier.toString();
        HashSet<Link> set = new HashSet<Link>();
        for (Link link : this.links.getSet()) {
            if (!link.getKind().getIdentifier().equals(identifierString)) continue;
            set.add(link);
        }
        return set;
    }

    public boolean removeLink(Link link) {
        return this.links.remove(link);
    }

    public void clearLinks() {
        this.links.clear();
    }

    public Set<Link> getLinks() {
        return this.links.getSet();
    }

    public boolean containsAction(Action action) {
        return this.actions.contains(action);
    }

    public boolean containsAction(String actionIdentifier) {
        return this.actions.contains(actionIdentifier);
    }

    public boolean addAction(Action action) {
        return this.actions.add(action);
    }

    public boolean addActions(Collection<Action> actions) {
        return this.actions.addAll(actions);
    }

    public Action getAction(String actionIdentifier) {
        return this.actions.get(actionIdentifier);
    }

    public boolean removeAction(Action action) {
        return this.actions.remove(action);
    }

    public void clearActions() {
        this.actions.clear();
    }

    public Set<Action> getActions() {
        return this.actions.getSet();
    }

    public String getLocation() {
        return this.getKind().getLocation().toString() + this.getId();
    }

    @Override
    public String getDefaultKindIdentifier() {
        return KIND_IDENTIFIER_DEFAULT;
    }

    public static List<Attribute> getDefaultAttributes() {
        ArrayList<Attribute> list = new ArrayList<Attribute>();
        list.addAll(Entity.getDefaultAttributes());
        list.add(new Attribute(SUMMARY_ATTRIBUTE_NAME, false, false));
        return list;
    }

    public static Kind getDefaultKind() {
        Kind kind = new Kind(SCHEME_DEFAULT, TERM_DEFAULT, "Resource", URI.create("/resource/"), Resource.getDefaultAttributes());
        return kind;
    }

    @Override
    public String toString() {
        return "Resource{class=" + this.getClass().getName() + ", id=" + this.getId() + ", kind=" + this.getKind() + ", title=" + this.getTitle() + ", mixins=" + this.getMixins() + ", attributes=" + this.getAttributes() + ", links" + this.links + '}';
    }

    @Override
    public String toText() throws RenderingException {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getKind().toText(false));
        ArrayList<Mixin> mixinList = new ArrayList<Mixin>(this.getMixins());
        Collections.sort(mixinList);
        for (Mixin m : mixinList) {
            sb.append("\n");
            sb.append(m.toText(false));
        }
        String attributesString = this.attributesToPrefixText();
        if (!attributesString.isEmpty()) {
            sb.append("\n");
            sb.append(attributesString);
        }
        ArrayList<Link> linkList = new ArrayList<Link>(this.getLinks());
        Collections.sort(linkList);
        for (Link l : linkList) {
            sb.append("\n");
            sb.append(l.toInlineText());
        }
        ArrayList<Action> actionList = new ArrayList<Action>(this.getActions());
        Collections.sort(actionList);
        for (Action a : actionList) {
            sb.append("\n");
            sb.append(a.toText(this.getKind().getLocation().toString() + this.getId()));
        }
        return sb.toString();
    }

    @Override
    public Headers toHeaders() throws RenderingException {
        Headers headers = new Headers();
        headers.putAll(this.getKind().toHeaders(false));
        ArrayList<Mixin> mixinList = new ArrayList<Mixin>(this.getMixins());
        Collections.sort(mixinList);
        for (Mixin m : mixinList) {
            Headers mixinHeaders = m.toHeaders(false);
            for (String name : mixinHeaders.keySet()) {
                Iterator<Object> i$ = mixinHeaders.get(name).iterator();
                while (i$.hasNext()) {
                    String value = (String)i$.next();
                    headers.add(name, value);
                }
            }
        }
        Headers attributeHeaders = this.attributesToHeaders();
        if (!attributeHeaders.isEmpty()) {
            headers.putAll(attributeHeaders);
        }
        ArrayList<Link> linkList = new ArrayList<Link>(this.getLinks());
        Collections.sort(linkList);
        for (Link l : linkList) {
            Headers linkHeaders = l.toInlineHeaders();
            for (String name : linkHeaders.keySet()) {
                Iterator i$ = linkHeaders.get(name).iterator();
                while (i$.hasNext()) {
                    String value = (String)i$.next();
                    headers.add(name, value);
                }
            }
        }
        ArrayList<Action> actionList = new ArrayList<Action>(this.getActions());
        Collections.sort(actionList);
        for (Action a : actionList) {
            Headers actionHeaders = a.toHeaders(this.getKind().getLocation().toString() + this.getId());
            for (String name : actionHeaders.keySet()) {
                Iterator i$ = actionHeaders.get(name).iterator();
                while (i$.hasNext()) {
                    String value = (String)i$.next();
                    headers.add(name, value);
                }
            }
        }
        return headers;
    }

    @Override
    public String toJSON() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

