/*
 * Decompiled with CFR 0.152.
 */
package cz.cesnet.cloud.occi.infrastructure;

import cz.cesnet.cloud.occi.Model;
import cz.cesnet.cloud.occi.core.Attribute;
import cz.cesnet.cloud.occi.core.Category;
import cz.cesnet.cloud.occi.core.Kind;
import cz.cesnet.cloud.occi.core.Link;
import cz.cesnet.cloud.occi.exception.InvalidAttributeValueException;
import cz.cesnet.cloud.occi.infrastructure.enumeration.NetworkState;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

public class NetworkInterface
extends Link {
    public static final String INTERFACE_ATTRIBUTE_NAME = "occi.networkinterface.interface";
    public static final String MAC_ATTRIBUTE_NAME = "occi.networkinterface.mac";
    public static final String STATE_ATTRIBUTE_NAME = "occi.networkinterface.state";
    public static final URI SCHEME_DEFAULT = Category.SCHEME_INFRASTRUCTURE_DEFAULT;
    public static final String TERM_DEFAULT = "networkinterface";
    public static final String KIND_IDENTIFIER_DEFAULT = SCHEME_DEFAULT + "networkinterface";

    public NetworkInterface(String id, Kind kind, String title, Model model) throws InvalidAttributeValueException {
        super(id, kind, title, model);
    }

    public NetworkInterface(String id, Kind kind) throws InvalidAttributeValueException {
        super(id, kind);
    }

    public String getNetworkInterface() {
        return this.getValue(INTERFACE_ATTRIBUTE_NAME);
    }

    public void setNetworkInterface(String networkInterface) throws InvalidAttributeValueException {
        this.addAttribute(INTERFACE_ATTRIBUTE_NAME, networkInterface);
    }

    public String getMac() {
        return this.getValue(MAC_ATTRIBUTE_NAME);
    }

    public void setMac(String mac) throws InvalidAttributeValueException {
        this.addAttribute(MAC_ATTRIBUTE_NAME, mac);
    }

    public String getState() {
        return this.getValue(STATE_ATTRIBUTE_NAME);
    }

    public void setState(NetworkState state) throws InvalidAttributeValueException {
        if (state == null) {
            throw new NullPointerException("state cannot be null");
        }
        this.addAttribute(STATE_ATTRIBUTE_NAME, state.toString());
    }

    public void setState(String stateName) throws InvalidAttributeValueException {
        this.addAttribute(STATE_ATTRIBUTE_NAME, stateName);
    }

    @Override
    public String getDefaultKindIdentifier() {
        return KIND_IDENTIFIER_DEFAULT;
    }

    public static List<Attribute> getDefaultAttributes() {
        ArrayList<Attribute> list = new ArrayList<Attribute>();
        list.addAll(Link.getDefaultAttributes());
        list.add(new Attribute(INTERFACE_ATTRIBUTE_NAME, true, true));
        list.add(new Attribute(MAC_ATTRIBUTE_NAME, true, false));
        list.add(new Attribute(STATE_ATTRIBUTE_NAME, true, true));
        return list;
    }

    public static Kind getDefaultKind() {
        Kind kind = new Kind(SCHEME_DEFAULT, TERM_DEFAULT, "Networkinterface", URI.create("/networkinterface/"), NetworkInterface.getDefaultAttributes());
        return kind;
    }
}

