/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.core;

import java.security.interfaces.RSAPublicKey;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.Object;
import scs.core.IComponent;
import scs.core.IComponentHelper;
import tecgraf.openbus.core.v2_0.services.access_control.AccessControl;
import tecgraf.openbus.core.v2_0.services.access_control.AccessControlHelper;
import tecgraf.openbus.core.v2_0.services.access_control.LoginRegistry;
import tecgraf.openbus.core.v2_0.services.access_control.LoginRegistryHelper;
import tecgraf.openbus.core.v2_0.services.offer_registry.OfferRegistry;
import tecgraf.openbus.core.v2_0.services.offer_registry.OfferRegistryHelper;
import tecgraf.openbus.exception.CryptographyException;
import tecgraf.openbus.exception.OpenBusInternalException;
import tecgraf.openbus.security.Cryptography;

final class BusInfo {
    private Object rawObject;
    private String id;
    private RSAPublicKey publicKey;
    private IComponent bus;
    private AccessControl accessControl;
    private LoginRegistry loginRegistry;
    private OfferRegistry offerRegistry;
    private java.lang.Object lockLogin = new java.lang.Object();
    private java.lang.Object lockOffer = new java.lang.Object();

    BusInfo(Object obj) {
        this.rawObject = obj;
        if (this.rawObject == null) {
            throw new OpenBusInternalException("Refer\u00eancia inv\u00e1lida para o barramento.");
        }
    }

    void basicBusInitialization() {
        boolean existent = false;
        try {
            if (this.rawObject != null && !this.rawObject._non_existent()) {
                existent = true;
            }
        }
        catch (OBJECT_NOT_EXIST e) {
            existent = false;
        }
        if (!existent) {
            throw new OpenBusInternalException("Barramento n\u00e3o esta acess\u00edvel.");
        }
        if (this.rawObject._is_a(IComponentHelper.id())) {
            this.bus = IComponentHelper.narrow((Object)this.rawObject);
        }
        if (this.bus == null) {
            throw new OpenBusInternalException("Refer\u00eancia obtida n\u00e3o corresponde a um IComponent.");
        }
        Object obj = this.bus.getFacet(AccessControlHelper.id());
        this.accessControl = AccessControlHelper.narrow(obj);
        this.retrieveBusIdAndKey();
    }

    void retrieveBusIdAndKey() {
        this.id = this.accessControl.busid();
        try {
            this.publicKey = Cryptography.getInstance().generateRSAPublicKeyFromX509EncodedKey(this.accessControl.buskey());
        }
        catch (CryptographyException e) {
            throw new OpenBusInternalException("Erro ao construir chave p\u00fablica do barramento.", e);
        }
    }

    void clearBusInfos() {
        this.id = null;
        this.publicKey = null;
        this.bus = null;
        this.accessControl = null;
        this.loginRegistry = null;
        this.offerRegistry = null;
    }

    String getId() {
        return this.id;
    }

    RSAPublicKey getPublicKey() {
        return this.publicKey;
    }

    AccessControl getAccessControl() {
        return this.accessControl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LoginRegistry getLoginRegistry() {
        java.lang.Object object = this.lockLogin;
        synchronized (object) {
            if (this.loginRegistry == null) {
                Object obj = this.bus.getFacet(LoginRegistryHelper.id());
                this.loginRegistry = LoginRegistryHelper.narrow(obj);
            }
        }
        return this.loginRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OfferRegistry getOfferRegistry() {
        java.lang.Object object = this.lockOffer;
        synchronized (object) {
            if (this.offerRegistry == null) {
                Object obj = this.bus.getFacet(OfferRegistryHelper.id());
                this.offerRegistry = OfferRegistryHelper.narrow(obj);
            }
        }
        return this.offerRegistry;
    }
}

