/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.core;

import java.lang.ref.WeakReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.ORBPackage.InvalidName;
import tecgraf.openbus.Connection;
import tecgraf.openbus.core.ConnectionImpl;
import tecgraf.openbus.core.OpenBusContextImpl;
import tecgraf.openbus.core.v2_0.services.access_control.AccessControl;

final class LeaseRenewer {
    private static final Logger logger = Logger.getLogger(LeaseRenewer.class.getName());
    private static final String RENEWER_THREAD_NAME = "RenewerThread";
    private RenewerTask renewer;
    private Thread renewerThread;

    public LeaseRenewer(Connection conn, int defaultLease) {
        this.renewer = new RenewerTask(conn, defaultLease);
    }

    public synchronized void start() {
        if (this.renewerThread != null) {
            this.stop();
        }
        this.renewerThread = new Thread((Runnable)this.renewer, RENEWER_THREAD_NAME);
        this.renewerThread.setDaemon(true);
        this.renewerThread.start();
    }

    public synchronized void stop() {
        if (this.renewerThread != null) {
            this.renewer.finish();
            if (this.renewer.isSleeping()) {
                this.renewerThread.interrupt();
            }
            this.renewerThread = null;
        }
    }

    private static class RenewerTask
    implements Runnable {
        private volatile boolean mustContinue = true;
        private volatile boolean isSleeping = false;
        private WeakReference<Connection> weakConn;
        private int defaultLease;

        RenewerTask(Connection conn, int defaultLease) {
            this.weakConn = new WeakReference<Connection>(conn);
            this.defaultLease = defaultLease;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.mustContinue) {
                Connection conn = (Connection)this.weakConn.get();
                if (conn == null) {
                    this.mustContinue = false;
                    break;
                }
                OpenBusContextImpl connections = null;
                int lease = -1;
                try {
                    connections = (OpenBusContextImpl)conn.orb().resolve_initial_references("OpenBusContext");
                    connections.setCurrentConnection(conn);
                    AccessControl manager = ((ConnectionImpl)conn).access();
                    if (manager != null) {
                        lease = manager.renew();
                        this.mustContinue &= lease > 0;
                    }
                }
                catch (InvalidName e) {
                    String message = "Falha inesperada ao obter o multiplexador";
                    logger.log(Level.SEVERE, message, e);
                    this.mustContinue = false;
                }
                catch (NO_PERMISSION ne) {
                    this.mustContinue = false;
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Falha na renova\u00e7\u00e3o da credencial", e);
                }
                finally {
                    if (connections != null) {
                        connections.setCurrentConnection(null);
                    }
                }
                if (!this.mustContinue) continue;
                try {
                    int time = lease;
                    if (time < 0) {
                        time = this.defaultLease;
                    }
                    this.isSleeping = true;
                    Thread.sleep(time * 1000);
                    this.isSleeping = false;
                }
                catch (InterruptedException e) {
                    this.mustContinue = false;
                    this.isSleeping = false;
                    break;
                }
            }
        }

        public void finish() {
            this.mustContinue = false;
        }

        public boolean isSleeping() {
            return this.isSleeping;
        }
    }
}

