/*
 * Decompiled with CFR 0.152.
 */
package demo;

import demo.Clock;
import demo.ClockHelper;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.TRANSIENT;
import tecgraf.openbus.assistant.Assistant;
import tecgraf.openbus.assistant.AssistantParams;
import tecgraf.openbus.core.v2_0.services.ServiceFailure;
import tecgraf.openbus.core.v2_0.services.offer_registry.ServiceOfferDesc;
import tecgraf.openbus.core.v2_0.services.offer_registry.ServiceProperty;
import tecgraf.openbus.exception.AlreadyLoggedIn;

public final class IndependentClockClient {
    private static String host;
    private static int port;
    private static String entity;
    private static String password;
    private static int interval;
    private static AtomicReference<Clock> clock;
    private static AtomicBoolean searching;
    private static AtomicBoolean shutdown;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static void main(String[] args) throws AlreadyLoggedIn, InvalidName, ServiceFailure {
        if (args.length < 3) {
            params = "[interval]";
            desc = "\n  - [interval] = Tempo de espera entre tentativas de acesso ao barramento em virtude de falhas. Valor padr\u00e3o \u00e9 '1'";
            System.out.println(String.format("Usage: 'demo' <host> <port> <entity> [password] %s\n  - host = \u00e9 o host do barramento\n  - port = \u00e9 a porta do barramento\n  - entity = \u00e9 a entidade a ser autenticada\n  - password = senha (opcional) %s", new java.lang.Object[]{params, desc}));
            System.exit(1);
            return;
        }
        IndependentClockClient.host = args[0];
        try {
            IndependentClockClient.port = Integer.parseInt(args[1]);
        }
        catch (NumberFormatException e) {
            System.out.println("Valor de <port> deve ser um n\u00famero");
            System.exit(1);
            return;
        }
        IndependentClockClient.password = IndependentClockClient.entity = args[2];
        if (args.length > 3) {
            IndependentClockClient.password = args[3];
        }
        if (args.length > 4) {
            try {
                IndependentClockClient.interval = Integer.parseInt(args[4]);
            }
            catch (NumberFormatException e) {
                System.out.println("Valor de [interval] deve ser um n\u00famero");
                System.exit(1);
                return;
            }
        }
        params = new AssistantParams();
        params.interval = IndependentClockClient.interval;
        assist = Assistant.createWithPassword((String)IndependentClockClient.host, (int)IndependentClockClient.port, (String)IndependentClockClient.entity, (byte[])IndependentClockClient.password.getBytes(), (AssistantParams)params);
        IndependentClockClient.activateSearch(assist);
        for (i = 0; i < 20; ++i) {
            timestamp = System.currentTimeMillis();
            aClock = IndependentClockClient.clock.get();
            if (aClock != null) {
                failed = true;
                try {
                    timestamp = aClock.getTimeInTicks();
                    failed = false;
                }
                catch (TRANSIENT e) {
                    System.err.println("o servi\u00e7o encontrado encontra-se indispon\u00edvel");
                }
                catch (COMM_FAILURE e) {
                    System.err.println("falha de comunica\u00e7\u00e3o com o servi\u00e7o encontrado");
                }
                catch (NO_PERMISSION e) {
                    switch (e.minor) {
                        case 1112888319: {
                            System.err.println(String.format("n\u00e3o h\u00e1 um login de '%s' v\u00e1lido no momento", new java.lang.Object[]{IndependentClockClient.entity}));
                            ** break;
lbl50:
                            // 1 sources

                            break;
                        }
                        case 1112888068: {
                            System.err.println("o servi\u00e7o encontrado n\u00e3o est\u00e1 mais logado ao barramento");
                            ** break;
lbl54:
                            // 1 sources

                            break;
                        }
                        case 1112888067: {
                            System.err.println("o servi\u00e7o encontrado n\u00e3o foi capaz de validar a chamada");
                            ** break;
lbl58:
                            // 1 sources

                            break;
                        }
                        case 1112888318: {
                            System.err.println("integra\u00e7\u00e3o do servi\u00e7o encontrado com o barramento est\u00e1 incorreta");
                            break;
                        }
                        ** default:
lbl63:
                        // 1 sources

                        break;
                    }
                }
                finally {
                    if (failed) {
                        IndependentClockClient.clock.set(null);
                        IndependentClockClient.activateSearch(assist);
                    }
                }
            }
            date = new Date(timestamp);
            formatter = new SimpleDateFormat("HH:mm:ss:SSS");
            System.out.println(formatter.format(date));
            try {
                Thread.sleep(IndependentClockClient.interval * 1000);
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        IndependentClockClient.shutdown.set(true);
        assist.shutdown();
        System.out.println("cliente deslogado...");
    }

    private static void activateSearch(final Assistant assist) {
        if (searching.compareAndSet(false, true)) {
            Thread finder = new Thread(){

                @Override
                public void run() {
                    IndependentClockClient.find(assist);
                }
            };
            finder.start();
        }
    }

    private static void find(Assistant assist) {
        clock.set(null);
        do {
            ServiceProperty[] properties = new ServiceProperty[]{new ServiceProperty("offer.domain", "Demo Independent Clock")};
            ServiceOfferDesc[] services = null;
            try {
                services = assist.findServices(properties, 0);
            }
            catch (ServiceFailure e) {
                System.err.println(String.format("falha severa no barramento em %s:%s : %s", host, port, e.message));
            }
            catch (TRANSIENT e) {
                System.err.println(String.format("o barramento em %s:%s esta inacess\u00edvel no momento", host, port));
            }
            catch (COMM_FAILURE e) {
                System.err.println("falha de comunica\u00e7\u00e3o ao acessar servi\u00e7os n\u00facleo do barramento");
            }
            catch (NO_PERMISSION e) {
                if (e.minor == 1112888319) {
                    System.err.println(String.format("n\u00e3o h\u00e1 um login de '%s' v\u00e1lido no momento", entity));
                }
            }
            catch (Throwable e) {
                System.err.println("Erro inesperado durante busca de servi\u00e7os.");
                e.printStackTrace();
            }
            boolean failed = true;
            if (services != null) {
                block19: for (ServiceOfferDesc offerDesc : services) {
                    try {
                        Object helloObj = offerDesc.service_ref.getFacet(ClockHelper.id());
                        if (helloObj == null) {
                            System.out.println("o servi\u00e7o encontrado n\u00e3o prov\u00ea a faceta ofertada");
                            continue;
                        }
                        clock.set(ClockHelper.narrow(helloObj));
                        failed = false;
                        break;
                    }
                    catch (TRANSIENT e) {
                        System.err.println("o servi\u00e7o encontrado encontra-se indispon\u00edvel");
                    }
                    catch (COMM_FAILURE e) {
                        System.err.println("falha de comunica\u00e7\u00e3o com o servi\u00e7o encontrado");
                    }
                    catch (NO_PERMISSION e) {
                        switch (e.minor) {
                            case 1112888319: {
                                System.err.println(String.format("n\u00e3o h\u00e1 um login de '%s' v\u00e1lido no momento", entity));
                                continue block19;
                            }
                            case 1112888068: {
                                System.err.println("o servi\u00e7o encontrado n\u00e3o est\u00e1 mais logado ao barramento");
                                continue block19;
                            }
                            case 1112888067: {
                                System.err.println("o servi\u00e7o encontrado n\u00e3o foi capaz de validar a chamada");
                                continue block19;
                            }
                            case 1112888318: {
                                System.err.println("integra\u00e7\u00e3o do servi\u00e7o encontrado com o barramento est\u00e1 incorreta");
                            }
                        }
                    }
                }
            }
            if (!failed) continue;
            System.err.println("servi\u00e7o esperado n\u00e3o foi encontrado.");
            try {
                Thread.sleep(interval * 1000);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        } while (clock.get() == null && !shutdown.get());
        searching.set(false);
    }

    static {
        interval = 1;
        clock = new AtomicReference();
        searching = new AtomicBoolean(false);
        shutdown = new AtomicBoolean(false);
    }
}

