/*
 * Decompiled with CFR 0.152.
 */
package demo;

import demo.Hello;
import demo.HelloHelper;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.Object;
import org.omg.CORBA.TRANSIENT;
import tecgraf.openbus.assistant.Assistant;
import tecgraf.openbus.assistant.AuthArgs;
import tecgraf.openbus.core.v2_0.services.ServiceFailure;
import tecgraf.openbus.core.v2_0.services.access_control.LoginProcess;
import tecgraf.openbus.core.v2_0.services.access_control.LoginProcessHelper;
import tecgraf.openbus.core.v2_0.services.offer_registry.ServiceOfferDesc;
import tecgraf.openbus.core.v2_0.services.offer_registry.ServiceProperty;

public class SharedAuthClient {
    public static void main(String[] args) {
        ServiceOfferDesc[] services;
        int port;
        String help = "Usage: 'demo' <host> <port> [file] \n  - host = \u00e9 o host do barramento\n  - port = \u00e9 a porta do barramento\n  - file = arquivo com informa\u00e7\u00f5es do compartilhamento de autentica\u00e7\u00e3o (opcional)";
        if (args.length < 2) {
            System.out.println(String.format(help, "", ""));
            System.exit(1);
            return;
        }
        String host = args[0];
        try {
            port = Integer.parseInt(args[1]);
        }
        catch (NumberFormatException e) {
            System.out.println("Valor de <port> deve ser um n\u00famero");
            System.exit(1);
            return;
        }
        final String file = args.length > 2 ? args[2] : "sharedauth.dat";
        Assistant assist = new Assistant(host, port){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public AuthArgs onLoginAuthentication() {
                AuthArgs authArgs;
                FileReader freader = new FileReader(file);
                BufferedReader breader = new BufferedReader(freader);
                try {
                    LoginProcess process = LoginProcessHelper.narrow((Object)this.orb().string_to_object(breader.readLine()));
                    byte[] secret = breader.readLine().getBytes();
                    breader.close();
                    authArgs = new AuthArgs(process, secret);
                }
                catch (Throwable throwable) {
                    try {
                        breader.close();
                        throw throwable;
                    }
                    catch (IOException e) {
                        System.err.println("Erro ao ler recuperar dados de arquivo.");
                        e.printStackTrace();
                        return null;
                    }
                }
                breader.close();
                return authArgs;
            }
        };
        ServiceProperty[] properties = new ServiceProperty[]{new ServiceProperty("offer.domain", "Demo Hello")};
        try {
            services = assist.findServices(properties, -1);
        }
        catch (ServiceFailure e) {
            System.err.println(String.format("falha severa no barramento em %s:%s : %s", host, port, e.message));
            System.exit(1);
            return;
        }
        catch (TRANSIENT e) {
            System.err.println(String.format("o barramento em %s:%s esta inacess\u00edvel no momento", host, port));
            System.exit(1);
            return;
        }
        catch (COMM_FAILURE e) {
            System.err.println("falha de comunica\u00e7\u00e3o ao acessar servi\u00e7os n\u00facleo do barramento");
            System.exit(1);
            return;
        }
        catch (NO_PERMISSION e) {
            if (e.minor == 1112888319) {
                System.err.println("n\u00e3o h\u00e1 um login v\u00e1lido no momento");
            }
            System.exit(1);
            return;
        }
        catch (Throwable e) {
            System.err.println("Erro inesperado durante busca de servi\u00e7os.");
            e.printStackTrace();
            System.exit(1);
            return;
        }
        block18: for (ServiceOfferDesc offerDesc : services) {
            try {
                Object helloObj = offerDesc.service_ref.getFacet(HelloHelper.id());
                if (helloObj == null) {
                    System.out.println("o servi\u00e7o encontrado n\u00e3o prov\u00ea a faceta ofertada");
                    continue;
                }
                Hello hello = HelloHelper.narrow(helloObj);
                hello.sayHello();
            }
            catch (TRANSIENT e) {
                System.err.println("o servi\u00e7o encontrado encontra-se indispon\u00edvel");
            }
            catch (COMM_FAILURE e) {
                System.err.println("falha de comunica\u00e7\u00e3o com o servi\u00e7o encontrado");
            }
            catch (NO_PERMISSION e) {
                switch (e.minor) {
                    case 1112888319: {
                        System.err.println("n\u00e3o h\u00e1 um login v\u00e1lido no momento");
                        continue block18;
                    }
                    case 1112888068: {
                        System.err.println("o servi\u00e7o encontrado n\u00e3o est\u00e1 mais logado ao barramento");
                        continue block18;
                    }
                    case 1112888067: {
                        System.err.println("o servi\u00e7o encontrado n\u00e3o foi capaz de validar a chamada");
                        continue block18;
                    }
                    case 1112888318: {
                        System.err.println("integra\u00e7\u00e3o do servi\u00e7o encontrado com o barramento est\u00e1 incorreta");
                    }
                }
            }
        }
        assist.shutdown();
    }
}

