/*
 * Decompiled with CFR 0.152.
 */
package demo;

import demo.Messenger;
import demo.MessengerHelper;
import demo.MessengerPOA;
import demo.Unauthorized;
import demo.Unavailable;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.Object;
import org.omg.CORBA.TRANSIENT;
import tecgraf.openbus.CallerChain;
import tecgraf.openbus.OpenBusContext;
import tecgraf.openbus.core.v2_0.services.offer_registry.ServiceOfferDesc;
import tecgraf.openbus.demo.util.Utils;

public class ProxyMessengerImpl
extends MessengerPOA {
    private OpenBusContext context;
    private String entity;
    private ServiceOfferDesc[] offers;

    public ProxyMessengerImpl(OpenBusContext context, String entity) {
        this.context = context;
        this.entity = entity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void showMessage(String message) throws Unavailable, Unauthorized {
        CallerChain chain = this.context.getCallerChain();
        System.out.println(String.format("repassando mensagem de %s", Utils.chain2str((CallerChain)chain)));
        this.context.joinChain(chain);
        for (ServiceOfferDesc offer : this.offers) {
            boolean failed = true;
            try {
                Object facet = offer.service_ref.getFacet(MessengerHelper.id());
                Messenger messenger = MessengerHelper.narrow(facet);
                messenger.showMessage(message);
                failed = false;
            }
            catch (TRANSIENT e) {
                System.err.println("o servi\u00e7o encontrado encontra-se indispon\u00edvel");
            }
            catch (COMM_FAILURE e) {
                System.err.println("falha de comunica\u00e7\u00e3o com o servi\u00e7o encontrado");
            }
            catch (NO_PERMISSION e) {
                switch (e.minor) {
                    case 1112888319: {
                        System.err.println(String.format("n\u00e3o h\u00e1 um login de '%s' v\u00e1lido no momento", this.entity));
                    }
                    case 1112888068: {
                        System.err.println("o servi\u00e7o encontrado n\u00e3o est\u00e1 mais logado ao barramento");
                    }
                    case 1112888067: {
                        System.err.println("o servi\u00e7o encontrado n\u00e3o foi capaz de validar a chamada");
                    }
                    case 1112888318: {
                        System.err.println("integra\u00e7\u00e3o do servi\u00e7o encontrado com o barramento est\u00e1 incorreta");
                    }
                    default: 
                }
            }
            finally {
                if (failed) continue;
                return;
            }
        }
        System.err.println("servi\u00e7os encontrados n\u00e3o est\u00e3o dispon\u00edveis");
        throw new Unavailable();
    }

    public void setOffers(ServiceOfferDesc[] offers) {
        this.offers = offers;
    }
}

