/*
 * Decompiled with CFR 0.152.
 */
package demo;

import demo.Hello;
import demo.HelloHelper;
import demo.interceptor.ContextInspector;
import demo.interceptor.SpecializedORBInitializer;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.TRANSIENT;
import tecgraf.openbus.Connection;
import tecgraf.openbus.OpenBusContext;
import tecgraf.openbus.core.v2_0.services.ServiceFailure;
import tecgraf.openbus.core.v2_0.services.access_control.AccessDenied;
import tecgraf.openbus.core.v2_0.services.offer_registry.ServiceOfferDesc;
import tecgraf.openbus.core.v2_0.services.offer_registry.ServiceProperty;
import tecgraf.openbus.exception.AlreadyLoggedIn;

public final class HelloClient {
    public static void main(String[] args) throws AlreadyLoggedIn, InvalidName, ServiceFailure {
        ServiceOfferDesc[] services;
        String entity;
        int port;
        if (args.length < 3) {
            System.out.println(String.format("Usage: 'demo' <host> <port> <entity> [password] %s\n  - host = \u00e9 o host do barramento\n  - port = \u00e9 a porta do barramento\n  - entity = \u00e9 a entidade a ser autenticada\n  - password = senha (opcional) %s", "", ""));
            System.exit(1);
            return;
        }
        String host = args[0];
        try {
            port = Integer.parseInt(args[1]);
        }
        catch (NumberFormatException e) {
            System.out.println("Valor de <port> deve ser um n\u00famero");
            System.exit(1);
            return;
        }
        String password = entity = args[2];
        if (args.length > 3) {
            password = args[3];
        }
        ORB orb = SpecializedORBInitializer.initORB();
        ContextInspector inspector = ContextInspector.getContextInspector(orb);
        inspector.setContextInformation("Sou a informa\u00e7\u00e3o passada via contexto.");
        OpenBusContext context = (OpenBusContext)orb.resolve_initial_references("OpenBusContext");
        Connection connection = context.createConnection(host, port);
        context.setDefaultConnection(connection);
        try {
            connection.loginByPassword(entity, password.getBytes());
            ServiceProperty[] properties = new ServiceProperty[]{new ServiceProperty("offer.domain", "Demo Hello")};
            services = context.getOfferRegistry().findServices(properties);
        }
        catch (AccessDenied e) {
            System.err.println(String.format("a senha fornecida para a entidade '%s' foi negada", entity));
            System.exit(1);
            return;
        }
        catch (ServiceFailure e) {
            System.err.println(String.format("falha severa no barramento em %s:%s : %s", host, port, e.message));
            System.exit(1);
            return;
        }
        catch (TRANSIENT e) {
            System.err.println(String.format("o barramento em %s:%s esta inacess\u00edvel no momento", host, port));
            System.exit(1);
            return;
        }
        catch (COMM_FAILURE e) {
            System.err.println("falha de comunica\u00e7\u00e3o ao acessar servi\u00e7os n\u00facleo do barramento");
            System.exit(1);
            return;
        }
        catch (NO_PERMISSION e) {
            if (e.minor == 1112888319) {
                System.err.println(String.format("n\u00e3o h\u00e1 um login de '%s' v\u00e1lido no momento", entity));
            }
            System.exit(1);
            return;
        }
        block18: for (ServiceOfferDesc offerDesc : services) {
            try {
                Object helloObj = offerDesc.service_ref.getFacet(HelloHelper.id());
                if (helloObj == null) {
                    System.out.println("o servi\u00e7o encontrado n\u00e3o prov\u00ea a faceta ofertada");
                    continue;
                }
                Hello hello = HelloHelper.narrow(helloObj);
                hello.sayHello();
            }
            catch (TRANSIENT e) {
                System.err.println("o servi\u00e7o encontrado encontra-se indispon\u00edvel");
            }
            catch (COMM_FAILURE e) {
                System.err.println("falha de comunica\u00e7\u00e3o com o servi\u00e7o encontrado");
            }
            catch (NO_PERMISSION e) {
                switch (e.minor) {
                    case 1112888319: {
                        System.err.println(String.format("n\u00e3o h\u00e1 um login de '%s' v\u00e1lido no momento", entity));
                        continue block18;
                    }
                    case 1112888068: {
                        System.err.println("o servi\u00e7o encontrado n\u00e3o est\u00e1 mais logado ao barramento");
                        continue block18;
                    }
                    case 1112888067: {
                        System.err.println("o servi\u00e7o encontrado n\u00e3o foi capaz de validar a chamada");
                        continue block18;
                    }
                    case 1112888318: {
                        System.err.println("integra\u00e7\u00e3o do servi\u00e7o encontrado com o barramento est\u00e1 incorreta");
                    }
                }
            }
        }
        context.getCurrentConnection().logout();
    }
}

