/*
 * Decompiled with CFR 0.152.
 */
package demo.interceptor;

import demo.interceptor.ContextInspector;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.LocalObject;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecPackage.FormatMismatch;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.InvalidSlot;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;

public class ServerInterceptor
extends LocalObject
implements ServerRequestInterceptor {
    ContextInspector inspector;

    public ServerInterceptor(ContextInspector contextInspector) {
        this.inspector = contextInspector;
    }

    public void receive_request(ServerRequestInfo info) throws ForwardRequest {
        byte[] encodedData;
        int slotId = this.inspector.getMySlotId();
        Codec codec = this.inspector.getCodec();
        int contextId = this.inspector.getContextId();
        try {
            ServiceContext context = info.get_request_service_context(contextId);
            encodedData = context.context_data;
        }
        catch (BAD_PARAM e) {
            switch (e.minor) {
                case 23: 
                case 26: {
                    return;
                }
            }
            throw e;
        }
        if (encodedData != null) {
            try {
                Any any = codec.decode(encodedData);
                info.set_slot(slotId, any);
            }
            catch (InvalidSlot e) {
                String msg = "Erro inesperado ao acessar slot.";
                System.err.println(msg);
                throw new INTERNAL(msg, 0, CompletionStatus.COMPLETED_NO);
            }
            catch (FormatMismatch e) {
                String msg = "Erro inesperado ao decodificar dado.";
                System.err.println(msg);
                throw new INTERNAL(msg, 0, CompletionStatus.COMPLETED_NO);
            }
        }
    }

    public void receive_request_service_contexts(ServerRequestInfo info) throws ForwardRequest {
    }

    public void send_exception(ServerRequestInfo arg0) throws ForwardRequest {
    }

    public void send_other(ServerRequestInfo arg0) throws ForwardRequest {
    }

    public void send_reply(ServerRequestInfo arg0) {
    }

    public void destroy() {
    }

    public String name() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }
}

