/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.interop.multiplexing.bythread;

import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.Servant;
import scs.core.ComponentContext;
import scs.core.ComponentId;
import scs.core.IComponent;
import tecgraf.openbus.CallDispatchCallback;
import tecgraf.openbus.Connection;
import tecgraf.openbus.InvalidLoginCallback;
import tecgraf.openbus.OpenBusContext;
import tecgraf.openbus.PrivateKey;
import tecgraf.openbus.core.ORBInitializer;
import tecgraf.openbus.core.OpenBusPrivateKey;
import tecgraf.openbus.core.v2_0.services.access_control.LoginInfo;
import tecgraf.openbus.core.v2_0.services.offer_registry.ServiceProperty;
import tecgraf.openbus.interop.multiplexing.bythread.HelloServant;
import tecgraf.openbus.interop.simple.HelloHelper;
import tecgraf.openbus.interop.util.Utils;

public class Server {
    public static void main(String[] args) {
        try {
            Properties props = Utils.readPropertyFile((String)"/test.properties");
            String host = props.getProperty("bus.host.name");
            String host2 = props.getProperty("bus2.host.name");
            int port = Integer.valueOf(props.getProperty("bus.host.port"));
            int port2 = Integer.valueOf(props.getProperty("bus2.host.port"));
            String entity = "interop_multiplexing_java_server";
            String privateKeyFile = "admin/InteropMultiplexing.key";
            Utils.setLogLevel((Level)Level.parse(props.getProperty("log.level", "OFF")));
            OpenBusPrivateKey privateKey = OpenBusPrivateKey.createPrivateKeyFromFile((String)privateKeyFile);
            ORB orb = ORBInitializer.initORB((String[])args);
            new Utils.ORBRunThread(orb).start();
            Utils.ShutdownThread shutdown = new Utils.ShutdownThread(orb);
            Runtime.getRuntime().addShutdownHook((Thread)shutdown);
            OpenBusContext context = (OpenBusContext)orb.resolve_initial_references("OpenBusContext");
            final Connection conn1AtBus1 = context.createConnection(host, port);
            Connection conn2AtBus1 = context.createConnection(host, port);
            final Connection connAtBus2 = context.createConnection(host2, port2);
            ArrayList<Connection> conns = new ArrayList<Connection>();
            conns.add(conn1AtBus1);
            conns.add(conn2AtBus1);
            conns.add(connAtBus2);
            POA poa1 = POAHelper.narrow((Object)orb.resolve_initial_references("RootPOA"));
            poa1.the_POAManager().activate();
            ComponentId id = new ComponentId("Hello", 1, 0, 0, "java");
            ComponentContext component1 = new ComponentContext(orb, poa1, id);
            component1.addFacet("hello", HelloHelper.id(), (Servant)new HelloServant(context));
            conn1AtBus1.loginByCertificate(entity, (PrivateKey)privateKey);
            conn2AtBus1.loginByCertificate(entity, (PrivateKey)privateKey);
            connAtBus2.loginByCertificate(entity, (PrivateKey)privateKey);
            shutdown.addConnetion(conn1AtBus1);
            shutdown.addConnetion(conn2AtBus1);
            shutdown.addConnetion(connAtBus2);
            final String busId1 = conn1AtBus1.busid();
            final String busId2 = connAtBus2.busid();
            context.onCallDispatch(new CallDispatchCallback(){

                public Connection dispatch(OpenBusContext context, String busid, String loginId, byte[] object_id, String operation) {
                    if (busId1.equals(busid)) {
                        return conn1AtBus1;
                    }
                    if (busId2.equals(busid)) {
                        return connAtBus2;
                    }
                    System.err.println("N\u00e3o encontrou dispatch!!!");
                    return null;
                }
            });
            RegisterThread thread1 = new RegisterThread(conn1AtBus1, context, component1.getIComponent());
            thread1.start();
            conn1AtBus1.onInvalidLoginCallback((InvalidLoginCallback)new Callback(conn1AtBus1, "conn1AtBus1"));
            RegisterThread thread2 = new RegisterThread(conn2AtBus1, context, component1.getIComponent());
            thread2.start();
            conn2AtBus1.onInvalidLoginCallback((InvalidLoginCallback)new Callback(conn2AtBus1, "conn2AtBus1"));
            context.setCurrentConnection(connAtBus2);
            context.getOfferRegistry().registerService(component1.getIComponent(), Server.getProps());
            connAtBus2.onInvalidLoginCallback((InvalidLoginCallback)new Callback(connAtBus2, "connAtBus2"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ServiceProperty[] getProps() {
        ServiceProperty[] serviceProperties = new ServiceProperty[]{new ServiceProperty("offer.domain", "Interoperability Tests")};
        return serviceProperties;
    }

    private static class RegisterThread
    extends Thread {
        private Connection conn;
        private OpenBusContext context;
        private IComponent component;

        public RegisterThread(Connection conn, OpenBusContext context, IComponent component) {
            this.conn = conn;
            this.context = context;
            this.component = component;
        }

        @Override
        public void run() {
            this.context.setCurrentConnection(this.conn);
            try {
                this.context.getOfferRegistry().registerService(this.component, Server.getProps());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static class Callback
    implements InvalidLoginCallback {
        private String name;
        private Connection conn;

        public Callback(Connection conn, String name) {
            this.name = name;
            this.conn = conn;
        }

        public void invalidLogin(Connection conn, LoginInfo login) {
            System.out.println("login terminated: " + this.name);
        }
    }
}

