/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.interop.multiplexing.mixed;

import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.Servant;
import scs.core.ComponentContext;
import scs.core.ComponentId;
import scs.core.IComponent;
import tecgraf.openbus.CallDispatchCallback;
import tecgraf.openbus.Connection;
import tecgraf.openbus.InvalidLoginCallback;
import tecgraf.openbus.OpenBusContext;
import tecgraf.openbus.PrivateKey;
import tecgraf.openbus.core.ORBInitializer;
import tecgraf.openbus.core.OpenBusPrivateKey;
import tecgraf.openbus.core.v2_0.services.access_control.LoginInfo;
import tecgraf.openbus.core.v2_0.services.offer_registry.ServiceProperty;
import tecgraf.openbus.interop.multiplexing.mixed.HelloServant;
import tecgraf.openbus.interop.simple.HelloHelper;
import tecgraf.openbus.interop.util.Utils;

public class Server {
    public static void main(String[] args) {
        try {
            Properties props = Utils.readPropertyFile((String)"/test.properties");
            String host = props.getProperty("bus.host.name");
            String host2 = props.getProperty("bus2.host.name");
            int port = Integer.valueOf(props.getProperty("bus.host.port"));
            int port2 = Integer.valueOf(props.getProperty("bus2.host.port"));
            String entity = "interop_multiplexing_java_server";
            String privateKeyFile = "admin/InteropMultiplexing.key";
            Utils.setLogLevel((Level)Level.parse(props.getProperty("log.level", "OFF")));
            OpenBusPrivateKey privateKey = OpenBusPrivateKey.createPrivateKeyFromFile((String)privateKeyFile);
            ORB orb1 = ORBInitializer.initORB((String[])args);
            new Utils.ORBRunThread(orb1).start();
            Utils.ShutdownThread shutdown1 = new Utils.ShutdownThread(orb1);
            Runtime.getRuntime().addShutdownHook((Thread)shutdown1);
            ORB orb2 = ORBInitializer.initORB((String[])args);
            new Utils.ORBRunThread(orb2).start();
            Utils.ShutdownThread shutdown2 = new Utils.ShutdownThread(orb2);
            Runtime.getRuntime().addShutdownHook((Thread)shutdown2);
            OpenBusContext context1 = (OpenBusContext)orb1.resolve_initial_references("OpenBusContext");
            OpenBusContext context2 = (OpenBusContext)orb2.resolve_initial_references("OpenBusContext");
            final Connection conn1AtBus1WithOrb1 = context1.createConnection(host, port);
            Connection conn2AtBus1WithOrb1 = context1.createConnection(host, port);
            final Connection conn1AtBus2WithOrb1 = context1.createConnection(host2, port2);
            final Connection conn3AtBus1WithOrb2 = context2.createConnection(host, port);
            ArrayList<Connection> conns = new ArrayList<Connection>();
            conns.add(conn1AtBus1WithOrb1);
            conns.add(conn1AtBus2WithOrb1);
            conns.add(conn3AtBus1WithOrb2);
            conn1AtBus1WithOrb1.onInvalidLoginCallback((InvalidLoginCallback)new Callback(conn1AtBus1WithOrb1, "conn1AtBus1WithOrb1"));
            conn2AtBus1WithOrb1.onInvalidLoginCallback((InvalidLoginCallback)new Callback(conn2AtBus1WithOrb1, "conn2AtBus1WithOrb1"));
            conn1AtBus2WithOrb1.onInvalidLoginCallback((InvalidLoginCallback)new Callback(conn1AtBus2WithOrb1, "connAtBus2WithOrb1"));
            conn3AtBus1WithOrb2.onInvalidLoginCallback((InvalidLoginCallback)new Callback(conn3AtBus1WithOrb2, "connAtBus1WithOrb2"));
            ComponentId id = new ComponentId("Hello", 1, 0, 0, "java");
            POA poa1 = POAHelper.narrow((Object)orb1.resolve_initial_references("RootPOA"));
            poa1.the_POAManager().activate();
            ComponentContext component1 = new ComponentContext(orb1, poa1, id);
            component1.addFacet("Hello", HelloHelper.id(), (Servant)new HelloServant(context1));
            POA poa2 = POAHelper.narrow((Object)orb2.resolve_initial_references("RootPOA"));
            poa2.the_POAManager().activate();
            ComponentContext component2 = new ComponentContext(orb2, poa2, id);
            component2.addFacet("Hello", HelloHelper.id(), (Servant)new HelloServant(context2));
            conn1AtBus1WithOrb1.loginByCertificate(entity, (PrivateKey)privateKey);
            conn2AtBus1WithOrb1.loginByCertificate(entity, (PrivateKey)privateKey);
            conn3AtBus1WithOrb2.loginByCertificate(entity, (PrivateKey)privateKey);
            conn1AtBus2WithOrb1.loginByCertificate(entity, (PrivateKey)privateKey);
            final String busId1 = conn1AtBus1WithOrb1.busid();
            final String busId2 = conn1AtBus2WithOrb1.busid();
            context1.onCallDispatch(new CallDispatchCallback(){

                public Connection dispatch(OpenBusContext context, String busid, String loginId, byte[] object_id, String operation) {
                    if (busId1.equals(busid)) {
                        return conn1AtBus1WithOrb1;
                    }
                    if (busId2.equals(busid)) {
                        return conn1AtBus2WithOrb1;
                    }
                    System.err.println("N\u00e3o encontrou dispatch!!!");
                    return null;
                }
            });
            shutdown1.addConnetion(conn1AtBus1WithOrb1);
            shutdown1.addConnetion(conn2AtBus1WithOrb1);
            shutdown1.addConnetion(conn1AtBus2WithOrb1);
            shutdown2.addConnetion(conn3AtBus1WithOrb2);
            RegisterThread thread1 = new RegisterThread(conn1AtBus1WithOrb1, context1, component1.getIComponent());
            thread1.start();
            RegisterThread thread2 = new RegisterThread(conn2AtBus1WithOrb1, context1, component1.getIComponent());
            thread2.start();
            context1.setCurrentConnection(conn1AtBus2WithOrb1);
            context1.getOfferRegistry().registerService(component1.getIComponent(), Server.getProps());
            context2.setCurrentConnection(conn3AtBus1WithOrb2);
            context2.onCallDispatch(new CallDispatchCallback(){

                public Connection dispatch(OpenBusContext context, String busid, String loginId, byte[] object_id, String operation) {
                    if (busId1.equals(busid)) {
                        return conn3AtBus1WithOrb2;
                    }
                    System.err.println("N\u00e3o encontrou dispatch!!!");
                    return null;
                }
            });
            context2.getOfferRegistry().registerService(component2.getIComponent(), Server.getProps());
            context2.setCurrentConnection(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ServiceProperty[] getProps() {
        ServiceProperty[] serviceProperties = new ServiceProperty[]{new ServiceProperty("offer.domain", "Interoperability Tests")};
        return serviceProperties;
    }

    private static class RegisterThread
    extends Thread {
        private Connection conn;
        private OpenBusContext context;
        private IComponent component;

        public RegisterThread(Connection conn, OpenBusContext context, IComponent component) {
            this.conn = conn;
            this.context = context;
            this.component = component;
        }

        @Override
        public void run() {
            this.context.setCurrentConnection(this.conn);
            try {
                this.context.getOfferRegistry().registerService(this.component, Server.getProps());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static class Callback
    implements InvalidLoginCallback {
        private String name;
        private Connection conn;

        public Callback(Connection conn, String name) {
            this.name = name;
            this.conn = conn;
        }

        public void invalidLogin(Connection conn, LoginInfo login) {
            System.out.println("login terminated: " + this.name);
        }
    }
}

