/*
 * Decompiled with CFR 0.152.
 */
package scs.core.servant;

import java.util.ArrayList;
import java.util.Map;
import org.omg.CORBA.Object;
import scs.core.AlreadyConnected;
import scs.core.ConnectionDescription;
import scs.core.ExceededConnectionLimit;
import scs.core.IReceptaclesPOA;
import scs.core.InvalidConnection;
import scs.core.InvalidName;
import scs.core.NoConnection;
import scs.core.servant.ComponentContext;
import scs.core.servant.Receptacle;

public class IReceptaclesServant
extends IReceptaclesPOA {
    private int connectionCounter = 0;
    private final int connectionLimit = 100;
    protected ComponentContext myComponent;

    public IReceptaclesServant(ComponentContext componentContext) {
        this.myComponent = componentContext;
    }

    protected Receptacle findReceptacle(String string) {
        return this.myComponent.getReceptacles().get(string);
    }

    protected Receptacle findReceptacleByConnection(int n) {
        for (Receptacle receptacle : this.myComponent.getReceptacles().values()) {
            if (receptacle.getConnection(n) == null) continue;
            return receptacle;
        }
        return null;
    }

    public int connect(String string, Object object) throws InvalidName, InvalidConnection, AlreadyConnected, ExceededConnectionLimit {
        Receptacle receptacle = this.findReceptacle(string);
        if (receptacle == null) {
            throw new InvalidName();
        }
        if (!receptacle.getReceptacleDescription().is_multiplex && !receptacle.getConnections().isEmpty()) {
            throw new AlreadyConnected();
        }
        if (this.connectionCounter >= this.connectionLimit) {
            throw new ExceededConnectionLimit();
        }
        if (!object._is_a(receptacle.getInterfaceName())) {
            throw new InvalidConnection();
        }
        return receptacle.addConnection(++this.connectionCounter, object);
    }

    public void disconnect(int n) throws InvalidConnection, NoConnection {
        if (n < 0) {
            throw new InvalidConnection();
        }
        Receptacle receptacle = this.findReceptacleByConnection(n);
        if (receptacle == null) {
            throw new NoConnection();
        }
        receptacle.removeConnection(n);
    }

    public ConnectionDescription[] getConnections(String string) throws InvalidName {
        Receptacle receptacle = this.myComponent.getReceptacles().get(string);
        if (receptacle == null) {
            throw new InvalidName();
        }
        ArrayList<ConnectionDescription> arrayList = receptacle.getConnections();
        return arrayList.toArray(new ConnectionDescription[arrayList.size()]);
    }

    public Map<String, Receptacle> getReceptacles() {
        return this.myComponent.getReceptacles();
    }

    public Object _get_component() {
        return this.myComponent.getIComponent();
    }
}

