/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.worker.actors;

import akka.actor.AbstractActor;
import akka.actor.Props;
import akka.japi.Creator;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import tech.powerjob.worker.common.WorkerRuntime;
import tech.powerjob.worker.core.tracker.processor.ProcessorTracker;
import tech.powerjob.worker.core.tracker.processor.ProcessorTrackerPool;
import tech.powerjob.worker.persistence.TaskDO;
import tech.powerjob.worker.pojo.request.TaskTrackerStartTaskReq;
import tech.powerjob.worker.pojo.request.TaskTrackerStopInstanceReq;

public class ProcessorTrackerActor
extends AbstractActor {
    private static final Logger log = LoggerFactory.getLogger(ProcessorTrackerActor.class);
    private final WorkerRuntime workerRuntime;

    public static Props props(WorkerRuntime workerRuntime) {
        return Props.create(ProcessorTrackerActor.class, (Creator & Serializable)() -> new ProcessorTrackerActor(workerRuntime));
    }

    public AbstractActor.Receive createReceive() {
        return this.receiveBuilder().match(TaskTrackerStartTaskReq.class, this::onReceiveTaskTrackerStartTaskReq).match(TaskTrackerStopInstanceReq.class, this::onReceiveTaskTrackerStopInstanceReq).matchAny(obj -> log.warn("[ProcessorTrackerActor] receive unknown request: {}.", obj)).build();
    }

    private void onReceiveTaskTrackerStartTaskReq(TaskTrackerStartTaskReq req) {
        Long instanceId = req.getInstanceInfo().getInstanceId();
        ProcessorTracker processorTracker = ProcessorTrackerPool.getProcessorTracker(instanceId, req.getTaskTrackerAddress(), () -> new ProcessorTracker(req, this.workerRuntime));
        TaskDO task = new TaskDO();
        task.setTaskId(req.getTaskId());
        task.setTaskName(req.getTaskName());
        task.setTaskContent(req.getTaskContent());
        task.setFailedCnt(req.getTaskCurrentRetryNums());
        task.setSubInstanceId(req.getSubInstanceId());
        processorTracker.submitTask(task);
    }

    private void onReceiveTaskTrackerStopInstanceReq(TaskTrackerStopInstanceReq req) {
        Long instanceId = req.getInstanceId();
        List<ProcessorTracker> removedPts = ProcessorTrackerPool.removeProcessorTracker(instanceId);
        if (!CollectionUtils.isEmpty(removedPts)) {
            removedPts.forEach(ProcessorTracker::destroy);
        }
    }

    public ProcessorTrackerActor(WorkerRuntime workerRuntime) {
        this.workerRuntime = workerRuntime;
    }
}

