/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.worker.common;

import java.util.concurrent.atomic.AtomicLong;
import tech.powerjob.worker.common.WorkerRuntime;
import tech.powerjob.worker.persistence.TaskDO;

public class ThreadLocalStore {
    private static final ThreadLocal<TaskDO> TASK_THREAD_LOCAL = new ThreadLocal();
    private static final ThreadLocal<WorkerRuntime> RUNTIME_META_LOCAL = new ThreadLocal();
    private static final ThreadLocal<AtomicLong> TASK_ID_THREAD_LOCAL = new ThreadLocal();

    public static TaskDO getTask() {
        return TASK_THREAD_LOCAL.get();
    }

    public static void setTask(TaskDO task) {
        TASK_THREAD_LOCAL.set(task);
    }

    public static WorkerRuntime getRuntimeMeta() {
        return RUNTIME_META_LOCAL.get();
    }

    public static void setRuntimeMeta(WorkerRuntime workerRuntime) {
        RUNTIME_META_LOCAL.set(workerRuntime);
    }

    public static AtomicLong getTaskIDAddr() {
        if (TASK_ID_THREAD_LOCAL.get() == null) {
            TASK_ID_THREAD_LOCAL.set(new AtomicLong(0L));
        }
        return TASK_ID_THREAD_LOCAL.get();
    }

    public static void clear() {
        TASK_ID_THREAD_LOCAL.remove();
        RUNTIME_META_LOCAL.remove();
        TASK_THREAD_LOCAL.remove();
    }
}

