/*
 * Decompiled with CFR 0.152.
 */
package uk.org.lidalia.sysoutslf4j.system;

import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import uk.org.lidalia.sysoutslf4j.common.LoggerAppender;

class LoggerAppenderStore {
    private final Map<ClassLoader, WeakReference<LoggerAppender>> loggerAppenderMap = new WeakHashMap<ClassLoader, WeakReference<LoggerAppender>>();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock readLock = this.lock.readLock();
    private final Lock writeLock = this.lock.writeLock();

    LoggerAppenderStore() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LoggerAppender get() {
        this.readLock.lock();
        try {
            LoggerAppender loggerAppender = this.get(this.contextClassLoader());
            return loggerAppender;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private LoggerAppender get(ClassLoader classLoader) {
        WeakReference<LoggerAppender> loggerAppenderReference = this.loggerAppenderMap.get(classLoader);
        LoggerAppender result = loggerAppenderReference == null ? (classLoader == null ? null : this.get(classLoader.getParent())) : (LoggerAppender)loggerAppenderReference.get();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void put(LoggerAppender loggerAppender) {
        this.writeLock.lock();
        try {
            this.loggerAppenderMap.put(this.contextClassLoader(), new WeakReference<LoggerAppender>(loggerAppender));
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove() {
        this.writeLock.lock();
        try {
            this.loggerAppenderMap.remove(this.contextClassLoader());
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private ClassLoader contextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }
}

