/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.core.registration;

import ar.com.fdvs.dj.core.DJConstants;
import ar.com.fdvs.dj.core.layout.LayoutManager;
import ar.com.fdvs.dj.core.registration.EntitiesRegistrationException;
import ar.com.fdvs.dj.domain.CustomExpression;
import ar.com.fdvs.dj.domain.DynamicJasperDesign;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.entities.Entity;
import java.util.Collection;
import java.util.Iterator;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.design.JRDesignParameter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractEntityRegistrationManager
implements DJConstants {
    private static final Log log = LogFactory.getLog((Class)AbstractEntityRegistrationManager.class);
    private DynamicJasperDesign djd;
    private DynamicReport dynamicReport;
    private LayoutManager layoutManager;

    public AbstractEntityRegistrationManager(DynamicJasperDesign djd, DynamicReport dr, LayoutManager layoutManager) {
        this.djd = djd;
        this.dynamicReport = dr;
        this.layoutManager = layoutManager;
    }

    public final void registerEntities(Collection entities) throws EntitiesRegistrationException {
        log.debug((Object)"Registering entities.");
        try {
            if (entities != null) {
                Iterator it = entities.iterator();
                while (it.hasNext()) {
                    Entity entity = (Entity)it.next();
                    this.registerEntity(entity);
                }
            }
        }
        catch (RuntimeException e) {
            throw new EntitiesRegistrationException(e.getMessage(), e);
        }
    }

    protected abstract void registerEntity(Entity var1);

    protected abstract Object transformEntity(Entity var1) throws JRException;

    protected void registerCustomExpressionParameter(String name, CustomExpression customExpression) {
        if (customExpression == null) {
            log.debug((Object)("No customExpression for calculation for property " + name));
            return;
        }
        JRDesignParameter dparam = new JRDesignParameter();
        dparam.setName(name);
        dparam.setValueClassName(CustomExpression.class.getName());
        log.debug((Object)("Registering customExpression parameter for property " + name));
        try {
            this.getDjd().addParameter((JRParameter)dparam);
        }
        catch (JRException e) {
            throw new EntitiesRegistrationException(e.getMessage(), e);
        }
        this.getDjd().getParametersWithValues().put(name, customExpression);
    }

    public DynamicReport getDynamicReport() {
        return this.dynamicReport;
    }

    public LayoutManager getLayoutManager() {
        return this.layoutManager;
    }

    public DynamicJasperDesign getDjd() {
        return this.djd;
    }
}

