package csbase.client.applications.flowapplication.actions;

import java.awt.event.ActionEvent;

import csbase.client.applications.ApplicationImages;
import csbase.client.applications.flowapplication.FlowApplication;
import csbase.client.applications.flowapplication.graph.Graph;
import csbase.client.applications.flowapplication.graph.GraphElement;
import csbase.client.applications.flowapplication.graph.utils.GraphUpdateOperation;
import csbase.client.util.StandardErrorDialogs;

/**
 * Ao que atualiza os algoritmos pertencentes ao fluxo corrente para utilizar
 * as suas respectivas verses mais atuais (se existirem).
 * 
 * @author isabella
 */
public class UpdateAllVersionsAction extends FlowApplicationAction {
  /**
   * Cria a ao
   * 
   * @param application A aplicao na qual essa ao vai ser adicionada.
   */
  public UpdateAllVersionsAction(FlowApplication application) {
    super(application, ApplicationImages.ICON_REFRESH_16);
    setEnabled(false);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void handleActionPerformed(ActionEvent event) {
    FlowApplication application = getApplication();
    Graph graph = application.getWorkspace().getGraph();
    GraphUpdateOperation operation = new GraphUpdateOperation(graph);
    boolean result = operation.update();
    if (!result) {
      StandardErrorDialogs.showErrorDialog(application.getApplicationFrame(),
        getString("UpdateAllVersionsAction.error"));
    }
    updateEnabledStatus(graph);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasElementRemoved(Graph graph, GraphElement element) {
    updateEnabledStatus(graph);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasElementCreated(Graph graph, GraphElement element) {
    updateEnabledStatus(graph);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasChangedWorkspace(Graph graph) {
    updateEnabledStatus(graph);
  }

  /**
   * Habilita a ao, caso exista uma nova verso do algoritmo. Desabilita, caso
   * contrrio.
   * 
   * @param graph O grafo.
   */
  private void updateEnabledStatus(Graph graph) {
    setEnabled(GraphUpdateOperation.hasNewerVersion(graph));
  }

}
