package csbase.client.applications.flowapplication.graph;

import java.util.Collection;

/**
 * Define as ligaes do grafo de forma que fiquem somente com linhas
 * ortogonais.
 */
public class OrthogonalLinkGraphLayout implements GraphLayout {

  /**
   * {@inheritDoc}
   */
  @Override
  public void doLayout(Graph graph) {
    for (GraphLink link : graph.getLinkCollection()) {
      if (link.isWellFormed()) {
        link.breakAsOrthogonalLink();
      }
    }

  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean canApplyLayout(Graph graph) {
    Collection<GraphLink> linkCollection = graph.getLinkCollection();
    if (linkCollection.isEmpty()) {
      return false;
    }
    for (GraphLink link : linkCollection) {
      if (!link.isWellFormed()) {
        return false;
      }
    }
    return true;
  }
}
