/*
 * $Id: DirectoryContentsCellEditor.java 150777 2014-03-19 14:16:56Z oikawa $
 */
package csbase.client.desktop.dircontents;

import java.awt.Component;
import java.awt.Window;
import java.text.MessageFormat;

import javax.swing.AbstractCellEditor;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;

import tecgraf.javautils.core.lng.LNG;
import csbase.client.desktop.RemoteTask;
import csbase.client.util.ClientUtilities;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.ClientProjectFile;

/**
 * Classe responsvel pela edio das clulas de nome do arquivo da tabela de
 * contedo de diretrios.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class DirectoryContentsCellEditor extends AbstractCellEditor implements
  TableCellEditor {
  /**
   * Janela
   */
  private final Window ownerWindow;

  /**
   * Ttulo
   */
  private final String ownerTitle;

  /**
   * Arquivo
   */
  private ClientProjectFile file;

  /**
   * Componente de edio
   */
  private final JComponent component = new JTextField();

  /**
   * Mtodo chamado pela tabela assim que o usurio completar a edio.
   * 
   * @return valor a ser exibido na clula, aps a edio.
   */
  @Override
  public Object getCellEditorValue() {
    final String nameTrimmed = ((JTextField) component).getText().trim();
    if (!ClientUtilities.isValidFileName(nameTrimmed)) {
      StandardErrorDialogs.showErrorDialog(ownerWindow, ownerTitle,
        LNG.get("PRJ_PROJECT_FILE_NAME_CHARACTERES_ERROR"));
      return file;
    }
    /* Define e cria a RemoteTask */
    final RemoteTask<Void> task = new RemoteTask<Void>() {

      @Override
      protected void performTask() throws Exception {
        file.rename(nameTrimmed);
      }
    };
    task.execute(ownerWindow, ownerTitle, MessageFormat.format(
      LNG.get("PRJ_WAITING_RENAME_FILE"), new Object[] { file.getName() }));
    return file;
  }

  /**
   * Mtodo chamado pela tabela quando o usurio tenta editar uma de suas
   * clulas (com a condio de que a clula em questo estiver associada a esta
   * classe de edio).
   * 
   * @param table Tabela na qual est localizada a clula sendo editada.
   * @param value Valor atual contido na clula.
   * @param isSelected Indica se a clula est selecionada.
   * @param rowIndex ndice de linha da clula
   * @param vColIndex ndice de coluna da clula
   * 
   * @return caixa de texto para permitir a edio da clula.
   */
  @Override
  public Component getTableCellEditorComponent(final JTable table,
    final Object value, final boolean isSelected, final int rowIndex,
    final int vColIndex) {
    file = (ClientProjectFile) value;
    final String text = file.getName();
    ((JTextField) component).setText(text);
    return component;
  }

  /**
   * Construtor que recebe a janela pai e o ttulo, para exibio do dilogo de
   * erro, caso ocorra alguma situao inesperada.
   * 
   * @param ownerWindow janela pai
   * @param ownerTitle ttulo da janela pai
   */
  public DirectoryContentsCellEditor(final Window ownerWindow,
    final String ownerTitle) {
    this.ownerWindow = ownerWindow;
    this.ownerTitle = ownerTitle;
  }
}
