package csbase.client.project.tasks;

import java.awt.Window;

import csbase.logic.CommonClientProject;

/**
 * A classe <code>RemoveFilesTask</code> implementa uma tarefa que remove um ou
 * mais arquivos de um projeto.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class RemoveFilesTask extends CoreTask<Void> {

  /**
   * Caminhos dos arquivos a excluir.
   */
  private final String[][] paths;

  /**
   * O projeto que contm o arquivo.
   */
  private final CommonClientProject project;

  /**
   * Construtor.
   * 
   * @param project projeto que contm o arquivo.
   * @param path caminhos dos arquivos a excluir.
   */
  public RemoveFilesTask(CommonClientProject project, String[][] path) {
    this.project = project;
    this.paths = path;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void performTask() throws Exception {
    project.removeFiles(paths);
  }

  /**
   * Mtodo de convenincia para chamada automtica da task para mltiplos
   * arquivos.
   * 
   * @param owner janela-me para a task.
   * @param project o projeto
   * @param paths os paths
   * @return <code>true</code> se a tarefa executar com sucesso ou
   *         <code>false</code> caso contrrio.
   */
  static final public boolean runTask(Window owner,
    final CommonClientProject project, final String[][] paths) {
    final RemoveFilesTask task = new RemoveFilesTask(project, paths);
    final String projectName = project.getName();
    return task.execute(owner, new String[] { projectName });
  }

  /**
   * Mtodo de convenincia para chamada automtica da task para um nico
   * arquivo.
   * 
   * @param owner janela-me para a task.
   * @param project o projeto
   * @param paths os paths
   * @return <code>true</code> se a tarefa executar com sucesso ou
   *         <code>false</code> caso contrrio.
   */
  static final public boolean runTask(Window owner,
    final CommonClientProject project, final String[] paths) {
    final RemoveFilesTask task =
      new RemoveFilesTask(project, new String[][] { paths });
    final String projectName = project.getName();
    return task.execute(owner, new String[] { projectName });
  }
}