/*
 * $Id: DirectoryChooserMouserListener.java,v 1.1 2010/04/15 18:29:46 clinio Exp
 * $
 */
package csbase.client.util.filechooser;

import java.util.List;

import csbase.client.util.filechooser.filetablepanel.ClientFileTablePanel;
import csbase.client.util.filechooser.filetablepanel.ClientTableActionListener;
import csbase.logic.ClientFile;

/**
 * Listener de mouse
 * 
 * @author Tecgraf/PUC-Rio
 */
class ClientFileChooserActionListener implements ClientTableActionListener {

  /**
   * Chooser
   */
  final private ClientFileChooser chooser;

  /**
   * Construtor
   * 
   * @param chooser dilogo.
   */
  ClientFileChooserActionListener(ClientFileChooser chooser) {
    this.chooser = chooser;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionPerformed(ClientFileTablePanel panel, List<ClientFile> files) {
    if (files == null || files.size() == 0) {
      return;
    }

    final ClientFileChooserCardinality card = chooser.getCardinality();
    switch (card) {
      case SINGLE_CHOOSE:
        final ClientFile selected = files.get(0);
        treatSingleFile(selected);
        break;

      case MULTIPLE_CHOOSE:
        treatMultipleSelection(files);
        break;
    }
  }

  /**
   * Trata uma lista de arquivos.
   * 
   * @param files lista de arquivos.
   */
  private void treatMultipleSelection(List<ClientFile> files) {
    final int size = files.size();
    if (size == 1) {
      final ClientFile selected = files.get(0);
      treatSingleFile(selected);
    }
  }

  /**
   * Tratamento de um nico arquivo.
   * 
   * @param file arquivo.
   */
  private void treatSingleFile(final ClientFile file) {
    if (file.isDirectory()) {
      chooser.setCurrentDirectory(file);
      return;
    }
    if (!file.canRead()) {
      return;
    }
    if (chooser.getSelectionMode() != ClientFileChooserSelectionMode.DIRECTORIES_ONLY) {
      chooser.closeOnSingleFile(file);
    }
  }
}
