package csbase.client.util.table;

/**
 * <p>
 * tem da {@link ComboBoxCellView Clula de <i>Combobox</i>}: o tem que 
 * armazenado na clula de <i>combobox</i>.
 * </p>
 * 
 * <p>
 * Um tem possui um rtulo e um objeto do usurio. O rtulo  utilizado para
 * que o usurio da aplicao identifique o objeto, ou seja,  exibido na
 * interface grfica. O objeto  o dado real do sistema.
 * </p>
 */
public final class ComboBoxCellViewItem implements
  Comparable<ComboBoxCellViewItem> {
  /**
   * O rtulo do tem.
   */
  private String label;

  /**
   * A dica.
   */
  private String tip;
  
  /**
   * O valor.
   */
  private Object value;

  /**
   * Cria um tem.
   * 
   * @param label O rtulo (No aceita {@code null}).
   * @param value O valor (No aceita {@code null}).
   */
  public ComboBoxCellViewItem(String label, Object value) {
    setLabel(label);
    setValue(value);
  }

  /**
   * Cria um tem.
   * 
   * @param label O rtulo (No aceita {@code null}).
   * @param tip A dica ((Aceita {@code null}).
   * @param value O valor (No aceita {@code null}).
   */
  public ComboBoxCellViewItem(String label, String tip, Object value) {
    this(label, value);
    this.tip = tip;
  }

  public int compareTo(ComboBoxCellViewItem item) {
    return getLabel().compareToIgnoreCase(item.getLabel());
  }

  @Override
  public boolean equals(Object obj) {
    if (obj == null) {
      return false;
    }

    if (getClass() != obj.getClass()) {
      return false;
    }

    ComboBoxCellViewItem other = (ComboBoxCellViewItem) obj;
    if (!label.equals(other.label)) {
      return false;
    }

    return true;
  }

  /**
   * Obtm o rtulo.
   * 
   * @return .
   */
  public String getLabel() {
    return label;
  }

  /**
   * Obtm a dica.
   * 
   * @return a dica ou {@code null} se no houver dica.
   */
  public String getTip() {
    return tip;
  }

  /**
   * Obtm o valor.
   * 
   * @return .
   */
  public Object getValue() {
    return value;
  }

  @Override
  public int hashCode() {
    return label.hashCode();
  }

  /**
   * Atribui o rtulo a este tem.
   * 
   * @param label O rtulo (No aceita {@code null}).
   */
  private void setLabel(String label) {
    if (label == null) {
      throw new IllegalArgumentException("O parmetro label est nulo.");
    }
    this.label = label;
  }

  /**
   * Atribui um valor a este tem.
   * 
   * @param value O valor (No aceita {@code null}).
   */
  private void setValue(Object value) {
    if (value == null) {
      throw new IllegalArgumentException("O parmetro value est nulo.");
    }
    this.value = value;
  }
}
