/*
 * $Id: DirectoryContentsMouseAdapter.java 116866 2011-04-01 15:13:57Z cassino $
 */

package csbase.client.desktop.dircontents;

import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

import javax.swing.JTable;

import csbase.client.project.action.CommonFileOpenAction;
import csbase.logic.ClientProjectFile;

/**
 * Classe que ativa os menus pop-up na tabela de contedo do diretrio.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class DirectoryContentsMouseAdapter extends MouseAdapter {
  /**
   * Linha selecionada
   */
  int selectedRow;

  /**
   * Referncia para o painel onde est a tabela de arquivos
   */
  DirectoryContentsPanel dirContentsPanel;

  /**
   * Referncia para a tabela de arquivos
   */
  JTable table;

  /**
   * Permite a navegao dentro da tabela: se o usurio der 2 cliques sobre um
   * diretrio, a tabela passar a exibir o contedo deste diretrio.
   * 
   * @param e evento
   */
  @Override
  public void mouseClicked(final MouseEvent e) {
    if (e.getClickCount() == 2) {
      final int fileColIndex = dirContentsPanel.getFileColIndex();
      final int row = table.getSelectedRow();
      final ClientProjectFile file = (ClientProjectFile) table.getValueAt(row,
        fileColIndex);
      // Sincroniza com a seleo da rvore de diretrios
      if (file.isDirectory()) {
        dirContentsPanel.synchronizeSelection(file);
        return;
      }
      final CommonFileOpenAction openAction = new CommonFileOpenAction(
        dirContentsPanel);
      openAction.openFile(file);
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void mousePressed(final MouseEvent me) {
    if (me.isPopupTrigger()) {
      showPopupMenu(me);
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void mouseReleased(final MouseEvent me) {
    if (me.isPopupTrigger()) {
      showPopupMenu(me);
    }
  }

  /**
   * Exibe o menu popup
   * 
   * @param me evento do mouse
   */
  private void showPopupMenu(final MouseEvent me) {
    final int X = me.getX();
    final int Y = me.getY();
    if (dirContentsPanel.getSelectionCount() > 1) {
      // Mltiplos arquivos/diretrios foram selecionados
      if (dirContentsPanel.getPopupMultSelection() != null) {
        dirContentsPanel.configurePopupMultiSelection();
        dirContentsPanel.getPopupMultSelection().show(table, X, Y);
      }
    }
    else {
      final int row = table.rowAtPoint(new Point(X, Y));

      // Seleciona a linha clicada
      table.setRowSelectionInterval(row, row);
      final int fileColIndex = dirContentsPanel.getFileColIndex();
      final ClientProjectFile file = (ClientProjectFile) table.getValueAt(row,
        fileColIndex);
      if (file.isDirectory()) {
        if (dirContentsPanel.getPopupDir() != null) {
          dirContentsPanel.configurePopupDir();
          dirContentsPanel.getPopupDir().show(table, X, Y);
        }
      }
      else {
        // Arquivo foi clicado
        if (dirContentsPanel.getPopupFile() != null) {
          dirContentsPanel.configurePopupFile(file);
          dirContentsPanel.getPopupFile().show(table, X, Y);
        }
      }
    }
  }

  /**
   * Construtor.
   * 
   * @param panel componente que exibe o contedo do diretrio mostrado na
   *        rvore
   */
  public DirectoryContentsMouseAdapter(final DirectoryContentsPanel panel) {
    dirContentsPanel = panel;
    table = dirContentsPanel.getTable();
  }
}
