/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.algorithms.commands.view;

import csbase.client.algorithms.commands.cache.CommandsCache;
import csbase.client.algorithms.commands.cache.events.AbstractCommandUpdatedEventListener;
import csbase.client.algorithms.commands.cache.events.CommandUpdatedEvent;
import csbase.client.algorithms.commands.view.ExportAction;
import csbase.client.algorithms.commands.view.ReloaderAction;
import csbase.client.algorithms.commands.view.Tab;
import csbase.logic.CommandInfo;
import csbase.logic.CommandStatus;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.Timer;

public abstract class AbstractConsolidatedLogTab
extends Tab {
    protected JTextArea textArea;
    private Timer reloader;
    private AtomicBoolean wasNeverSelected;
    private JToggleButton reloaderBtn;
    private JToggleButton exportBtn;
    protected CommandInfo command;

    public AbstractConsolidatedLogTab(CommandInfo commandInfo) {
        this.command = commandInfo;
        this.setLayout(new BorderLayout());
        this.textArea = new JTextArea();
        this.textArea.setFont(new Font("monospaced", 0, 12));
        this.textArea.setEditable(false);
        this.textArea.setBackground(new Color(220, 220, 220));
        this.reloader = this.createReloader();
        this.wasNeverSelected = new AtomicBoolean(true);
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        this.reloaderBtn = new JToggleButton();
        this.reloaderBtn.setSelected(this.reloader.isRunning());
        this.reloaderBtn.setAction(new ReloaderAction(this.reloaderBtn, this.reloader));
        toolBar.add(this.reloaderBtn);
        toolBar.add(new JToolBar.Separator());
        this.exportBtn = new JToggleButton();
        this.exportBtn.setSelected(false);
        this.exportBtn.setAction(new ExportAction(this.textArea));
        toolBar.add(this.exportBtn);
        this.add((Component)toolBar, "North");
        JScrollPane scrollpane = new JScrollPane(this.textArea);
        scrollpane.setPreferredSize(new Dimension(600, 300));
        this.add((Component)scrollpane, "Center");
        CommandsCache.getInstance().addEventListener(new AbstractCommandUpdatedEventListener(this.command.getProjectId(), this.command.getId()){

            @Override
            protected void eventFired(CommandUpdatedEvent.Type type, CommandInfo commandInfo) {
                AbstractConsolidatedLogTab.this.command = commandInfo;
                switch (type) {
                    case end: 
                    case error: 
                    case success: 
                    case failed: 
                    case killed: 
                    case lost: 
                    case removed: 
                    case no_code: {
                        AbstractConsolidatedLogTab.this.setSelected(false);
                    }
                }
            }
        });
    }

    public CommandInfo getCommand() {
        return this.command;
    }

    @Override
    protected void setSelected(boolean selected) {
        super.setSelected(selected);
        if (this.wasNeverSelected.compareAndSet(true, !selected)) {
            if (this.command.getStatus().equals((Object)CommandStatus.FINISHED)) {
                this.loadLog();
            } else {
                this.reloader.start();
                this.reloaderBtn.setSelected(true);
            }
            return;
        }
        if (!this.reloaderBtn.isSelected()) {
            return;
        }
        if (selected) {
            this.reloader.start();
            this.reloaderBtn.setSelected(true);
        } else {
            this.reloader.stop();
            this.reloaderBtn.setSelected(false);
        }
    }

    private Timer createReloader() {
        Timer reloadTimer = new Timer(3000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractConsolidatedLogTab.this.loadLog();
            }
        });
        reloadTimer.setInitialDelay(0);
        return reloadTimer;
    }

    protected abstract void loadLog();
}

