/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.algorithms.commands.view;

import csbase.client.algorithms.commands.view.AbstractAlgorithmCommandView;
import csbase.client.algorithms.commands.view.CommandViewType;
import csbase.client.algorithms.commands.view.FlowAlgorithmCommandView;
import csbase.client.algorithms.commands.view.SimpleAlgorithmCommandView;
import csbase.client.algorithms.commands.view.TabType;
import csbase.client.applications.flowapplication.graph.GraphNode;
import csbase.client.desktop.DesktopComponentFrame;
import csbase.client.desktop.RemoteTask;
import csbase.client.kernel.ClientException;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.CommandInfo;
import csbase.logic.algorithms.AlgorithmConfigurator;
import java.awt.Window;
import tecgraf.javautils.core.lng.LNG;

public class AlgorithmCommandViewFactory {
    private static final String VIEW_INDEX_TEMPLATE = "|%s|";
    private static final String NODE_INDEX_TEMPLATE = "|%s||%s|";

    public static void showView(DesktopComponentFrame owner, final CommandInfo command, TabType preferredTab) throws ClientException {
        if (command == null) {
            throw new IllegalArgumentException("O par\u00e2metro command est\u00e1 nulo.");
        }
        RemoteTask<AlgorithmConfigurator> task = new RemoteTask<AlgorithmConfigurator>(){

            public void performTask() throws Exception {
                AlgorithmConfigurator configurator = command.getConfigurator();
                this.setResult(configurator);
            }
        };
        String msg = LNG.get((String)"AlgorithmCommandViewFactory.loading.configurator");
        if (!task.execute(owner, msg, msg)) {
            return;
        }
        AlgorithmConfigurator configurator = (AlgorithmConfigurator)task.getResult();
        String index = String.format(VIEW_INDEX_TEMPLATE, command.getId());
        CommandViewType viewType = configurator.getConfiguratorType() == AlgorithmConfigurator.ConfiguratorType.FLOW ? CommandViewType.FLOW : CommandViewType.SIMPLE;
        AlgorithmCommandViewFactory.showView(index, owner, command, configurator, preferredTab, viewType, null);
    }

    public static void showView(DesktopComponentFrame owner, CommandInfo command, GraphNode node, TabType preferredTab) throws ClientException {
        if (command == null) {
            throw new IllegalArgumentException("O par\u00e2metro command est\u00e1 nulo.");
        }
        if (node == null) {
            throw new IllegalArgumentException("O par\u00e2metro node est\u00e1 nulo.");
        }
        AlgorithmConfigurator configurator = node.getAlgorithmConfiguratorView().getConfigurator();
        String index = String.format(NODE_INDEX_TEMPLATE, owner.getIndex(), node.getId());
        AlgorithmCommandViewFactory.showView(index, owner, command, configurator, preferredTab, CommandViewType.NODE, node.getId());
    }

    private static void showView(Object index, DesktopComponentFrame owner, CommandInfo command, AlgorithmConfigurator configurator, TabType preferredTab, CommandViewType logViewType, Integer nodeId) throws ClientException {
        if (command == null) {
            throw new IllegalArgumentException("N\u00e3o foi passado um comando para ser visualizado.");
        }
        AbstractAlgorithmCommandView view = (AbstractAlgorithmCommandView)DesktopComponentFrame.getDesktopComponentFrame(index);
        if (view == null) {
            view = AlgorithmCommandViewFactory.createView(index, owner, command, configurator, logViewType, nodeId);
        }
        if (view == null) {
            StandardErrorDialogs.showErrorDialog((Window)owner, LNG.get((String)"AlgorithmCommandViewFactory.error.view.unknown"));
        } else {
            view.show(preferredTab);
        }
    }

    private static AbstractAlgorithmCommandView createView(Object index, DesktopComponentFrame owner, CommandInfo command, AlgorithmConfigurator configurator, CommandViewType viewType, Integer nodeId) throws ClientException {
        if (configurator == null) {
            return null;
        }
        switch (viewType) {
            case FLOW: {
                return new FlowAlgorithmCommandView(index, owner, command, configurator);
            }
            case SIMPLE: {
                return new SimpleAlgorithmCommandView(index, owner, command, configurator, CommandViewType.SIMPLE, null);
            }
            case NODE: {
                return new SimpleAlgorithmCommandView(index, owner, command, configurator, CommandViewType.NODE, nodeId);
            }
        }
        return null;
    }
}

