/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.algorithms.parameters;

import csbase.client.algorithms.parameters.ComponentProperties;
import csbase.client.algorithms.parameters.ParameterView;
import csbase.client.algorithms.parameters.SimpleParameterView;
import csbase.logic.algorithms.parameters.EnumerationItem;
import csbase.logic.algorithms.parameters.EnumerationListParameter;
import csbase.logic.algorithms.parameters.EnumerationListParameterListener;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.selector.ContainerSelection;
import tecgraf.javautils.gui.selector.ContainerSelectionListener;
import tecgraf.javautils.gui.selector.ItemContainer;
import tecgraf.javautils.gui.table.DefaultObjectTableProvider;
import tecgraf.javautils.gui.table.ObjectTableProvider;
import tecgraf.javautils.gui.table.SortableTable;

public final class EnumerationListParameterView
extends SimpleParameterView<List<EnumerationItem>> {
    @Deprecated
    public EnumerationListParameterView(Window window, EnumerationListParameter parameter) {
        this(parameter, ParameterView.Mode.CONFIGURATION);
    }

    public EnumerationListParameterView(EnumerationListParameter parameter, ParameterView.Mode mode) {
        super(parameter, mode, new Object[0]);
        this.updateCapabilityView();
        this.updateVisibilyView();
    }

    @Override
    public EnumerationListParameter getParameter() {
        return (EnumerationListParameter)super.getParameter();
    }

    @Override
    protected JComponent createConfigurationComponent(Object ... componentArgs) {
        return new EnumerationListConfigurationParameter();
    }

    @Override
    protected JComponent createReportComponent(Object ... componentArgs) {
        return new EnumerationListReportParameter();
    }

    @Override
    protected void updateViewContents() {
        ((IEnumerationListParameterComponent)((Object)this.getComponent())).updateViewContents();
    }

    private String getString(String key) {
        return LNG.get((String)(String.valueOf(this.getClass().getName()) + "." + key));
    }

    @Override
    public boolean fillVerticalSpace() {
        return true;
    }

    private final class EnumerationListConfigurationParameter
    extends JPanel
    implements IEnumerationListParameterComponent {
        private ContainerSelection<EnumerationItem> containerSelection;

        EnumerationListConfigurationParameter() {
            this.setLayout(new GridBagLayout());
            this.containerSelection = new ContainerSelection((ObjectTableProvider)new MyObjectTableProvider(EnumerationListParameterView.this.getString("available_items")), (ObjectTableProvider)new MyObjectTableProvider(EnumerationListParameterView.this.getString("selected_items")), true, false, true, true, 0, false);
            this.containerSelection.loadItems((Collection)EnumerationListParameterView.this.getParameter().getItems());
            this.containerSelection.addContainerSelectionListener(new ContainerSelectionListener(){

                public void containerChanged() {
                    EnumerationListConfigurationParameter.this.updateModel();
                }
            });
            ItemContainer availableContainer = this.containerSelection.getAvailableContainer();
            SortableTable availableTable = availableContainer.getTable();
            availableTable.setDefaultRenderer(Object.class, (TableCellRenderer)new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    EnumerationItem item = (EnumerationItem)EnumerationListConfigurationParameter.this.containerSelection.getAvailableItems().get(row);
                    if (item.getDescription() != null) {
                        this.setToolTipText(item.getDescription());
                    } else {
                        this.setToolTipText(EnumerationListParameterView.this.getParameter().getDescription());
                    }
                    return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                }
            });
            availableTable.setToolTipText(EnumerationListParameterView.this.getParameter().getDescription());
            ItemContainer selectedContainer = this.containerSelection.getSelectedContainer();
            SortableTable selectTable = selectedContainer.getTable();
            selectTable.setDefaultRenderer(Object.class, (TableCellRenderer)new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    EnumerationItem item = (EnumerationItem)EnumerationListConfigurationParameter.this.containerSelection.getSelectedItems().get(row);
                    if (item.getDescription() != null) {
                        this.setToolTipText(item.getDescription());
                    } else {
                        this.setToolTipText(EnumerationListParameterView.this.getParameter().getDescription());
                    }
                    return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                }
            });
            selectTable.setToolTipText(EnumerationListParameterView.this.getParameter().getDescription());
            EnumerationListParameterView.this.getParameter().addEnumerationListParameterListener(new EnumerationListParameterListener(){

                public void itemsWereChanged(EnumerationListParameter parameter) {
                    EnumerationListConfigurationParameter.this.containerSelection.loadItems((Collection)parameter.getItems());
                }
            });
            this.updateViewContents();
            this.add((Component)this.containerSelection.getPanel(), new GBC(0, 0).both());
        }

        @Override
        public void updateViewContents() {
            List selectedItems = (List)EnumerationListParameterView.this.getParameter().getValue();
            if (selectedItems == null) {
                selectedItems = Collections.emptyList();
            }
            this.containerSelection.loadItems((Collection)EnumerationListParameterView.this.getParameter().getItems(), selectedItems);
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            this.containerSelection.setEnabled(isEnabled);
        }

        private void updateModel() {
            List selectedItems = this.containerSelection.getSelectedItems();
            if (selectedItems.isEmpty()) {
                EnumerationListParameterView.this.getParameter().setValue(null);
            } else {
                EnumerationListParameterView.this.getParameter().setValue(selectedItems);
            }
        }
    }

    private final class EnumerationListReportParameter
    extends JPanel
    implements IEnumerationListParameterComponent {
        private JTextArea textArea;

        EnumerationListReportParameter() {
            this.setLayout(new GridLayout());
            this.textArea = new JTextArea();
            this.textArea.setToolTipText(EnumerationListParameterView.this.getParameter().getDescription());
            ComponentProperties.setProperties(this.textArea, ParameterView.Mode.REPORT, false);
            JScrollPane scroll = new JScrollPane(this.textArea);
            scroll.setBorder(ComponentProperties.getInstance(ParameterView.Mode.REPORT).getBorder());
            this.updateViewContents();
            this.add((Component)scroll, new GBC(0, 0).both());
        }

        @Override
        public void updateViewContents() {
            List selectedItems = (List)EnumerationListParameterView.this.getParameter().getValue();
            if (selectedItems == null) {
                this.textArea.setRows(1);
            } else {
                this.textArea.setRows(Math.max(1, Math.min(selectedItems.size(), 6)));
                StringBuffer sb = new StringBuffer();
                for (EnumerationItem item : selectedItems) {
                    sb.append(item.getLabel()).append('\n');
                }
                String text = sb.substring(0, sb.length() - 1);
                this.textArea.setText(text);
            }
        }

        @Override
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            this.textArea.setEnabled(enabled);
        }
    }

    private static interface IEnumerationListParameterComponent {
        public void updateViewContents();
    }

    private final class MyObjectTableProvider
    extends DefaultObjectTableProvider {
        private String columnName;

        MyObjectTableProvider(String columnName) {
            this.columnName = columnName;
        }

        public String[] getColumnNames() {
            return new String[]{this.columnName};
        }

        public Class<?>[] getColumnClasses() {
            return new Class[]{String.class};
        }

        public Object[] getCellValues(Object row) {
            EnumerationItem item = (EnumerationItem)row;
            return new Object[]{item.getLabel()};
        }
    }
}

