/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.algorithms.parameters;

import csbase.client.algorithms.parameters.ComponentProperties;
import csbase.client.algorithms.parameters.ParameterView;
import csbase.client.algorithms.parameters.SimpleParameterView;
import csbase.client.util.ClientUtilities;
import csbase.logic.algorithms.parameters.ListParameter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import tecgraf.javautils.gui.GBC;

public abstract class ListParameterView<E>
extends SimpleParameterView<List<E>> {
    @Deprecated
    protected ListParameterView(Window window, ListParameter<E> parameter, Parser<E> parser, Formatter<E> formatter) {
        this(parameter, ParameterView.Mode.CONFIGURATION, parser, formatter);
    }

    protected ListParameterView(ListParameter<E> parameter, ParameterView.Mode mode, Parser<E> parser, Formatter<E> formatter) {
        this(parameter, mode, parser, formatter, null);
    }

    @Deprecated
    protected ListParameterView(Window window, ListParameter<E> parameter, Parser<E> parser, Formatter<E> formatter, JTextField textField) {
        this(parameter, ParameterView.Mode.CONFIGURATION, parser, formatter, textField);
    }

    protected ListParameterView(ListParameter<E> parameter, ParameterView.Mode mode, Parser<E> parser, Formatter<E> formatter, JTextField textField) {
        super(parameter, mode, new Object[]{parser, formatter, textField});
        this.updateCapabilityView();
        this.updateVisibilyView();
    }

    @Override
    public ListParameter<E> getParameter() {
        return (ListParameter)super.getParameter();
    }

    @Override
    protected JComponent createConfigurationComponent(Object ... componentArgs) {
        Parser parser = (Parser)componentArgs[0];
        Formatter formatter = (Formatter)componentArgs[1];
        JTextField textField = (JTextField)componentArgs[2];
        return new ListConfigurationParameter(parser, formatter, textField);
    }

    @Override
    protected JComponent createReportComponent(Object ... componentArgs) {
        Formatter formatter = (Formatter)componentArgs[1];
        return new ListReportParameter(formatter);
    }

    @Override
    protected void updateViewContents() {
        ((IListParameterComponent)((Object)this.getComponent())).updateViewContents();
    }

    @Override
    public boolean fillVerticalSpace() {
        return true;
    }

    protected static interface Formatter<E> {
        public String format(E var1);
    }

    private static interface IListParameterComponent {
        public void updateViewContents();
    }

    private final class ListConfigurationParameter
    extends JPanel
    implements IListParameterComponent {
        private Parser<E> parser;
        private Formatter<E> formatter;
        private final JButton addButton;
        private final JButton editButton;
        private final JList list;
        private final DefaultListModel model;
        private final JButton removeButton;
        private final JTextField textField;

        ListConfigurationParameter(Parser<E> parser, Formatter<E> formatter, JTextField textField) {
            this.setParser(parser);
            this.setFormatter(formatter);
            this.setLayout(new BorderLayout());
            this.textField = textField == null ? new JTextField(50) : textField;
            this.textField.addActionListener(new AddActionListener());
            this.textField.getDocument().addDocumentListener(new AddDocumentListener());
            this.textField.setToolTipText(ListParameterView.this.getParameter().getDescription());
            this.model = new DefaultListModel();
            this.list = new JList(this.model);
            this.list.getSelectionModel().setSelectionMode(2);
            this.list.addKeyListener(new RemoveKeyListener());
            this.list.addListSelectionListener(new EditListSelectionListener());
            Dimension preferredSize = this.textField.getPreferredSize();
            this.list.setFixedCellWidth((int)preferredSize.getWidth());
            this.list.setFixedCellHeight((int)preferredSize.getHeight());
            this.list.setToolTipText(ListParameterView.this.getParameter().getDescription());
            JPanel editPanel = new JPanel();
            editPanel.setLayout(new BorderLayout());
            editPanel.add((Component)this.textField, "North");
            editPanel.add((Component)new JScrollPane(this.list), "Center");
            this.add((Component)editPanel, "Center");
            this.addButton = new JButton("Adicionar");
            this.addButton.addActionListener(new AddActionListener());
            String description = ListParameterView.this.getParameter().getDescription();
            this.addButton.setToolTipText(description);
            this.addButton.setEnabled(false);
            this.editButton = new JButton("Editar...");
            this.editButton.addActionListener(new EditActionListener());
            this.editButton.setToolTipText(description);
            this.editButton.setEnabled(false);
            this.removeButton = new JButton("Remover");
            this.removeButton.addActionListener(new RemoveActionListener());
            this.removeButton.setToolTipText(description);
            this.removeButton.setEnabled(false);
            ClientUtilities.adjustEqualSizes(this.addButton, this.editButton, this.removeButton);
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new GridBagLayout());
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.anchor = 10;
            constraints.fill = 0;
            constraints.gridheight = 1;
            constraints.gridwidth = 1;
            constraints.gridx = 1;
            constraints.gridy = 1;
            constraints.insets = new Insets(2, 2, 2, 2);
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            buttonPanel.add((Component)this.addButton, constraints);
            ++constraints.gridy;
            buttonPanel.add((Component)this.editButton, constraints);
            ++constraints.gridy;
            buttonPanel.add((Component)this.removeButton, constraints);
            this.add((Component)buttonPanel, "East");
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            this.textField.setEnabled(isEnabled);
            this.list.setEnabled(isEnabled);
            this.updateAddButton();
            this.updateEditButton();
            this.updateRemoveButton();
        }

        @Override
        public void updateViewContents() {
            this.model.removeAllElements();
            List values = (List)ListParameterView.this.getParameter().getValue();
            if (values != null) {
                for (Object value : values) {
                    this.model.addElement(this.getFormatter().format(value));
                }
            }
        }

        private Formatter<E> getFormatter() {
            return this.formatter;
        }

        private Parser<E> getParser() {
            return this.parser;
        }

        private void setFormatter(Formatter<E> formatter) {
            if (formatter == null) {
                throw new IllegalArgumentException("O par\u00e2metro formatter est\u00e1 nulo.");
            }
            this.formatter = formatter;
        }

        private void setParser(Parser<E> parser) {
            if (parser == null) {
                throw new IllegalArgumentException("O par\u00e2metro parser est\u00e1 nulo.");
            }
            this.parser = parser;
        }

        private DefaultListModel getModel() {
            return this.model;
        }

        private void removeSelection() {
            int[] indices = this.list.getSelectedIndices();
            int i = 0;
            while (i < indices.length) {
                ListParameterView.this.getParameter().removeElement(indices[i] - i);
                ++i;
            }
        }

        private void restoreText() {
            this.textField.setText("");
            this.textField.requestFocus();
        }

        private void updateAddButton() {
            String rawText = this.textField.getText();
            Object object = this.getParser().parse(rawText);
            this.addButton.setEnabled(this.isEnabled() && object != null);
        }

        private void updateEditButton() {
            this.editButton.setEnabled(this.isEnabled() && !this.list.isSelectionEmpty());
        }

        private void updateRemoveButton() {
            this.removeButton.setEnabled(this.isEnabled() && !this.list.isSelectionEmpty());
        }

        private final class AddActionListener
        implements ActionListener {
            private AddActionListener() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ListConfigurationParameter.this.addButton.isEnabled()) {
                    String text = ListConfigurationParameter.this.textField.getText().trim();
                    Object element = ListConfigurationParameter.this.getParser().parse(text);
                    if (element != null) {
                        ListConfigurationParameter.this.getModel().addElement(ListConfigurationParameter.this.getFormatter().format(element));
                        ListParameter parameter = ListParameterView.this.getParameter();
                        parameter.addElement(element);
                        ListConfigurationParameter.this.restoreText();
                    }
                }
            }
        }

        private final class AddDocumentListener
        implements DocumentListener {
            private AddDocumentListener() {
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ListConfigurationParameter.this.updateAddButton();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                ListConfigurationParameter.this.updateAddButton();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ListConfigurationParameter.this.updateAddButton();
            }
        }

        private final class EditActionListener
        implements ActionListener {
            private EditActionListener() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                Object element;
                String text = JOptionPane.showInputDialog("Editar", ListConfigurationParameter.this.list.getSelectedValue());
                if (text != null && (element = ListConfigurationParameter.this.getParser().parse(text)) != null) {
                    int index = ListConfigurationParameter.this.list.getSelectedIndex();
                    ListConfigurationParameter.this.getModel().removeElementAt(index);
                    ListConfigurationParameter.this.getModel().add(index, ListConfigurationParameter.this.getFormatter().format(element));
                    ListParameterView.this.getParameter().setElement(index, element);
                }
                ListConfigurationParameter.this.restoreText();
            }
        }

        private final class EditListSelectionListener
        implements ListSelectionListener {
            private EditListSelectionListener() {
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (ListConfigurationParameter.this.list.isSelectionEmpty() || ListConfigurationParameter.this.list.getSelectedIndices().length > 1) {
                    ListConfigurationParameter.this.editButton.setEnabled(false);
                } else {
                    ListConfigurationParameter.this.editButton.setEnabled(true);
                }
                if (ListConfigurationParameter.this.list.isSelectionEmpty()) {
                    ListConfigurationParameter.this.removeButton.setEnabled(false);
                } else {
                    ListConfigurationParameter.this.removeButton.setEnabled(true);
                }
            }
        }

        private final class RemoveActionListener
        implements ActionListener {
            private RemoveActionListener() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ListConfigurationParameter.this.removeSelection();
                ListConfigurationParameter.this.restoreText();
            }
        }

        private final class RemoveKeyListener
        implements KeyListener {
            private RemoveKeyListener() {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                int keyCode = e.getKeyCode();
                switch (keyCode) {
                    case 8: 
                    case 127: {
                        ListConfigurationParameter.this.removeSelection();
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        }
    }

    private final class ListReportParameter
    extends JPanel
    implements IListParameterComponent {
        private final Formatter<E> formatter;
        private JTextArea textArea;

        ListReportParameter(Formatter<E> formatter) {
            this.formatter = formatter;
            this.setLayout(new GridLayout());
            this.textArea = new JTextArea();
            this.textArea.setToolTipText(ListParameterView.this.getParameter().getDescription());
            ComponentProperties.setProperties(this.textArea, ParameterView.Mode.REPORT, false);
            JScrollPane scroll = new JScrollPane(this.textArea);
            scroll.setBorder(ComponentProperties.getInstance(ParameterView.Mode.REPORT).getBorder());
            this.updateViewContents();
            this.add((Component)scroll, new GBC(0, 0).both());
        }

        @Override
        public void updateViewContents() {
            List values = (List)ListParameterView.this.getParameter().getValue();
            if (values == null) {
                this.textArea.setRows(1);
            } else {
                this.textArea.setRows(Math.max(1, Math.min(values.size(), 6)));
                StringBuffer sb = new StringBuffer();
                for (Object value : values) {
                    sb.append(this.formatter.format(value)).append('\n');
                }
                String text = sb.substring(0, sb.length() - 1);
                this.textArea.setText(text);
            }
        }

        @Override
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            this.textArea.setEnabled(enabled);
        }
    }

    protected static interface Parser<E> {
        public E parse(String var1);
    }
}

