/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.algorithms.tasks;

import csbase.client.desktop.DesktopFrame;
import csbase.client.desktop.RemoteTask;
import csbase.logic.CommonClientProject;
import csbase.logic.User;
import csbase.logic.algorithms.AlgorithmConfigurator;
import csbase.logic.algorithms.validation.LocalizedMessage;
import csbase.logic.algorithms.validation.Validation;
import csbase.logic.algorithms.validation.ValidationContext;
import csbase.logic.algorithms.validation.ValidationError;
import csbase.logic.algorithms.validation.ValidationMode;
import java.awt.Window;
import tecgraf.javautils.core.lng.LNG;

public class ConfiguratorValidationTask
extends RemoteTask<Validation> {
    protected AlgorithmConfigurator configurator;
    private ValidationMode mode;

    public ConfiguratorValidationTask(AlgorithmConfigurator configurator, ValidationMode mode) {
        this.configurator = configurator;
        this.mode = mode;
    }

    protected void performTask() throws Exception {
        CommonClientProject project = DesktopFrame.getInstance().getProject();
        Object projectId = project.getId();
        Object userId = User.getLoggedUser().getId();
        ValidationContext context = new ValidationContext(this.mode, projectId, userId);
        Validation result = this.configurator.validate(context);
        this.setResult(result);
    }

    public static final Validation runTask(Window window, AlgorithmConfigurator configurator, ValidationMode mode) {
        String msg;
        ConfiguratorValidationTask task = new ConfiguratorValidationTask(configurator, mode);
        String className = ConfiguratorValidationTask.class.getSimpleName();
        String title = LNG.get((String)(String.valueOf(className) + ".title"));
        if (task.execute(window, title, msg = LNG.get((String)(String.valueOf(className) + ".msg")))) {
            return (Validation)task.getResult();
        }
        if (task.wasCancelled()) {
            LocalizedMessage message = new LocalizedMessage(ConfiguratorValidationTask.class, "cancelled");
            return new ValidationError(message);
        }
        Exception error = task.getError();
        error.printStackTrace();
        LocalizedMessage errorMessage = new LocalizedMessage(ConfiguratorValidationTask.class, "error", new Object[]{error.getMessage()});
        return new ValidationError(errorMessage);
    }
}

