/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.algorithms.view;

import csbase.client.algorithms.AlgorithmConfiguratorView;
import csbase.client.algorithms.parameters.ParameterView;
import csbase.client.algorithms.validation.ViewValidationResult;
import csbase.client.algorithms.validation.ViewValidator;
import csbase.client.kernel.ClientException;
import csbase.logic.algorithms.AlgorithmConfigurator;
import csbase.logic.algorithms.validation.ValidationMode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import tecgraf.javautils.configurationmanager.Configuration;
import tecgraf.javautils.configurationmanager.ConfigurationManager;
import tecgraf.javautils.configurationmanager.ConfigurationManagerException;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GBC;

public abstract class AbstractAlgorithmConfiguratorPanel<T extends AlgorithmConfigurator>
extends JPanel
implements ViewValidator {
    private static ShowInnerButtons showInnerButtons;
    private final Window owner;
    private final T configurator;
    private AbstractParametersPanel parametersPanel;

    static {
        try {
            Configuration configuration = ConfigurationManager.getInstance().getConfiguration(AlgorithmConfiguratorView.class);
            showInnerButtons = ShowInnerButtons.valueOf(configuration.getOptionalProperty("show.inner.buttons", ShowInnerButtons.ALL.name()));
        }
        catch (ConfigurationManagerException e) {
            showInnerButtons = ShowInnerButtons.ALL;
        }
        catch (IllegalArgumentException e) {
            showInnerButtons = ShowInnerButtons.ALL;
        }
    }

    protected AbstractAlgorithmConfiguratorPanel(Window owner, T configurator, ParameterView.Mode mode) throws ClientException {
        this.owner = owner;
        this.configurator = configurator;
        this.initialize(mode);
    }

    public Window getOwner() {
        return this.owner;
    }

    public T getConfigurator() {
        return this.configurator;
    }

    public Window getWindow() {
        return SwingUtilities.windowForComponent(this);
    }

    @Override
    public boolean highlightValidationResult(ViewValidationResult result) {
        return this.parametersPanel.highlightValidationResult(result);
    }

    @Override
    public ViewValidationResult validate(ValidationMode validationMode) throws RemoteException {
        return this.parametersPanel.validate(validationMode);
    }

    public void resetValues() {
        this.getConfigurator().resetValues();
    }

    protected abstract AbstractParametersPanel createParametersReportPanel() throws ClientException;

    protected abstract AbstractParametersPanel createParametersConfigurationPanel() throws ClientException;

    private void initialize(ParameterView.Mode mode) throws ClientException {
        switch (mode) {
            case REPORT: {
                this.initializeInReportMode();
                break;
            }
            case CONFIGURATION: {
                this.initializeInConfigurationMode();
                break;
            }
            default: {
                throw new IllegalArgumentException("Modo de vis\u00e3o desconhecido.");
            }
        }
    }

    private void initializeInReportMode() throws ClientException {
        this.parametersPanel = this.createParametersReportPanel();
        this.setLayout(new GridLayout());
        this.add((Component)this.parametersPanel, new GBC(0, 0).both());
    }

    private void initializeInConfigurationMode() throws ClientException {
        this.parametersPanel = this.createParametersConfigurationPanel();
        if (ShowInnerButtons.NONE == showInnerButtons) {
            this.setLayout(new GridLayout());
            this.add((Component)this.parametersPanel, new GBC(0, 0).both());
        } else {
            this.setLayout(new BorderLayout());
            this.add((Component)this.parametersPanel, "Center");
            JPanel buttonsPanel = this.createButtonPanel();
            this.add((Component)buttonsPanel, "South");
        }
    }

    private JPanel createButtonPanel() {
        JPanel buttonsPanel = new JPanel(new FlowLayout(2));
        JButton restoreButton = new JButton(this.getString("resetDefaultValues"));
        restoreButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractAlgorithmConfiguratorPanel.this.resetValues();
            }
        });
        buttonsPanel.add(restoreButton);
        return buttonsPanel;
    }

    private String getString(String key) {
        return LNG.get((String)(String.valueOf(AlgorithmConfiguratorView.class.getName()) + "." + key));
    }

    protected abstract class AbstractParametersPanel
    extends JPanel
    implements ViewValidator {
        protected AbstractParametersPanel() {
        }
    }

    private static enum ShowInnerButtons {
        ALL,
        RESTORE_DEFAULT,
        NONE;

    }
}

