/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applicationmanager;

import csbase.client.applicationmanager.ApplicationLink;
import csbase.client.applicationmanager.Utilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyVetoException;
import java.util.Hashtable;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

class ApplicationGroupInternalFrame
extends JInternalFrame {
    private static final String WIDTH_INFO = "WIDTH_INFO";
    private static final int DEFAULT_WIDTH = 300;
    private static final String HEIGHT_INFO = "HEIGHT_INFO";
    private static final int DEFAULT_HEIGHT = 400;
    private static final String POS_X_INFO = "POS_X_INFO";
    private static final int DEFAULT_POS_X = 0;
    private static final String POS_Y_INFO = "POS_Y_INFO";
    private static final int DEFAULT_POS_Y = 0;
    private static final String SELECTED_INFO = "SELECTED_INFO";
    private static final String ICON_INFO = "ICON_INFO";
    private JPanel panel = new JPanel();

    public JPanel getPanel() {
        return this.panel;
    }

    public void setInfo(Hashtable<String, Integer> grpInfo) {
        int width = Utilities.getIntegerFromHash(grpInfo, WIDTH_INFO, 300);
        int height = Utilities.getIntegerFromHash(grpInfo, HEIGHT_INFO, 400);
        if (this.isMaximum()) {
            try {
                this.setMaximum(false);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        this.setSize(new Dimension(width, height));
        int x = Utilities.getIntegerFromHash(grpInfo, POS_X_INFO, 0);
        int y = Utilities.getIntegerFromHash(grpInfo, POS_Y_INFO, 0);
        this.setLocation(x, y);
        this.panel.setPreferredSize(this.panel.getParent().getSize());
        try {
            boolean selected = Utilities.getBooleanFromHash(grpInfo, SELECTED_INFO, false);
            if (selected) {
                this.setSelected(true);
            }
            boolean icon = Utilities.getBooleanFromHash(grpInfo, ICON_INFO, false);
            this.setIcon(icon);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public Hashtable<String, Object> getInfo() {
        Hashtable<String, Object> grpInfo = new Hashtable<String, Object>();
        grpInfo.put(WIDTH_INFO, new Integer(this.getWidth()));
        grpInfo.put(HEIGHT_INFO, new Integer(this.getHeight()));
        grpInfo.put(POS_X_INFO, new Integer(this.getX()));
        grpInfo.put(POS_Y_INFO, new Integer(this.getY()));
        grpInfo.put(ICON_INFO, new Boolean(this.isIcon()));
        grpInfo.put(SELECTED_INFO, new Boolean(this.isSelected()));
        return grpInfo;
    }

    public void adjustIcons() {
        this.panel.setPreferredSize(this.panel.getParent().getSize());
        this.panel.setLayout(new FlowLayout());
    }

    private Rectangle getLinksBounds() {
        Component[] cmps = this.panel.getComponents();
        if (cmps.length <= 0) {
            return null;
        }
        Rectangle rect = new Rectangle();
        Component[] componentArray = cmps;
        int n = cmps.length;
        int n2 = 0;
        while (n2 < n) {
            Component cmp = componentArray[n2];
            rect.add(cmp.getBounds());
            ++n2;
        }
        return rect;
    }

    private void addResizeListener() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (ApplicationGroupInternalFrame.this.panel.getLayout() != null) {
                    return;
                }
                ApplicationGroupInternalFrame.this.resizePanelBasedOnLinks();
            }
        });
    }

    private void resizePanelBasedOnLinks() {
        Rectangle rect = this.getLinksBounds();
        if (rect == null) {
            return;
        }
        this.panel.setPreferredSize(new Dimension(rect.width, rect.height));
    }

    public ApplicationGroupInternalFrame(String title, Icon icon, List<ApplicationLink> links) {
        super(title, true, false, true, true);
        JScrollPane scrollPane = new JScrollPane(this.panel);
        scrollPane.setSize(0, 0);
        this.getContentPane().add(scrollPane);
        this.setFrameIcon(icon);
        JInternalFrame.JDesktopIcon dskIcon = new JInternalFrame.JDesktopIcon(this);
        this.setDesktopIcon(dskIcon);
        this.setSize(300, 400);
        this.addResizeListener();
        this.setVisible(true);
        for (ApplicationLink link : links) {
            this.panel.add(link);
        }
    }
}

