/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applicationmanager.resourcehelpers;

import csbase.client.Client;
import csbase.client.applicationmanager.resourcehelpers.ApplicationResourceHelper;
import csbase.client.applicationmanager.resourcehelpers.ApplicationResourceType;
import csbase.client.applicationmanager.resourcehelpers.ApplicationResourceVersionFinder;
import csbase.client.applications.Application;
import csbase.logic.applicationservice.ApplicationRegistry;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.util.List;
import tecgraf.javautils.version.VersionNumber;
import tecgraf.javautils.version.VersionNumberTransition;
import tecgraf.javautils.version.VersionUtils;
import tecgraf.javautils.xml.conversion.XMLConversionInterface;
import tecgraf.javautils.xml.conversion.XMLConverter;
import tecgraf.javautils.xml.conversion.exception.XMLConversionException;
import tecgraf.javautils.xml.exception.XMLException;

public final class ApplicationDTDResourceHelper<T extends Application>
extends ApplicationResourceHelper<T> {
    private final XMLConverter createXMLConverter(String tag, VersionNumber fromVersion, VersionNumber toVersion) throws Exception {
        ApplicationResourceVersionFinder finder = new ApplicationResourceVersionFinder(this, tag);
        List versionsList = VersionUtils.getExistantVersionsList(finder, (VersionNumber)fromVersion, (VersionNumber)toVersion);
        if (versionsList.size() <= 0) {
            return null;
        }
        List transitionList = VersionUtils.getTransitionPairsList((List)versionsList);
        XMLConverter cnv = this.createXMLConverter(tag, transitionList);
        return cnv;
    }

    private XMLConverter createXMLConverter(String tag, List<VersionNumberTransition> transitionList) throws Exception {
        XMLConverter converter = new XMLConverter();
        Client client = Client.getInstance();
        converter.setEncoding(client.getSystemDefaultCharsetName());
        for (VersionNumberTransition transition : transitionList) {
            VersionNumber toVersion;
            VersionNumber fromVersion = transition.getFromVersion();
            XMLConversionInterface conversion = this.createConversion(tag, fromVersion, toVersion = transition.getToVersion());
            if (conversion == null) continue;
            converter.addConversion(conversion);
        }
        return converter;
    }

    private XMLConversionInterface createConversion(String tag, VersionNumber fromVersion, VersionNumber toVersion) throws Exception {
        Class<?> cnvClass;
        ApplicationRegistry reg = this.getApplicationRegistry();
        String appClassName = reg.getClassName();
        int idx = appClassName.lastIndexOf(".");
        String path = appClassName.substring(0, idx);
        String toId = toVersion.toStringAsTag();
        String fromId = fromVersion.toStringAsTag();
        String dirName = "dtdconversions";
        String cnvClassPrefix = "ConversionFor";
        String sufix = String.valueOf(tag) + "_" + fromId + "_To_" + toId;
        String cnvClassText = "dtdconversions.ConversionFor_" + sufix;
        String cnvClassName = String.valueOf(path) + "." + cnvClassText;
        Class<?> clazz = cnvClass = Class.forName(cnvClassName);
        Object application = this.getApplication();
        Class<VersionNumber> versionClass = VersionNumber.class;
        Class<?> appClass = application.getClass();
        Constructor<?> constructor = clazz.getConstructor(appClass, versionClass, versionClass, String.class);
        XMLConversionInterface conversion = (XMLConversionInterface)constructor.newInstance(application, fromVersion, toVersion, tag);
        return conversion;
    }

    public final InputStream buildConvertedInputStream(XMLConverter converter, String tag, InputStream inputStream) throws XMLConversionException, IOException {
        if (inputStream == null) {
            String err = "Null input stream!";
            throw new IOException("Null input stream!");
        }
        InputStreamReader reader = new InputStreamReader(inputStream);
        String urlPrefix = this.getResourceURLPrefix();
        converter.setDTDprefix(urlPrefix);
        String prefix = this.getClass().getSimpleName();
        File tmpFile = File.createTempFile(prefix, null);
        converter.convert((Reader)reader, true);
        converter.saveTo(tmpFile);
        FileInputStream stream = new FileInputStream(tmpFile);
        return stream;
    }

    public final String extractFileNameFromSystemId(String systemId) {
        String fileName;
        if (systemId == null) {
            return null;
        }
        if (systemId.startsWith("http://") || systemId.startsWith("file://")) {
            int idx = systemId.lastIndexOf("/");
            fileName = systemId.substring(idx);
        } else {
            fileName = systemId;
        }
        return fileName;
    }

    public final XMLConverter buildXMLConverter(String tag) throws Exception {
        ApplicationResourceVersionFinder finder = new ApplicationResourceVersionFinder(this, tag);
        VersionNumber fromVersion = VersionNumber.ZERO_VERSION;
        VersionNumber toVersion = this.getResourceVersionFromProperty(tag);
        List versionsList = VersionUtils.getExistantVersionsList(finder, (VersionNumber)fromVersion, (VersionNumber)toVersion);
        if (versionsList.size() <= 0) {
            return null;
        }
        XMLConverter cnv = this.createXMLConverter(tag, fromVersion, toVersion);
        return cnv;
    }

    public final String generateReadDTD(VersionNumber version, String tag) throws XMLException {
        if (version == null) {
            String err = "No version defined!";
            throw new XMLException("No version defined!");
        }
        if (!version.isValid()) {
            String err = "Invalid version defined!";
            throw new XMLException("Invalid version defined!");
        }
        String dtdPrefix = this.getResourceURLPrefix();
        String fileName = this.getVersionedFileName(tag, version);
        String dtd = String.valueOf(dtdPrefix) + "/" + fileName;
        return dtd;
    }

    public final String generateWriteDTD(String tag) throws XMLException {
        VersionNumber version = this.getResourceVersionFromProperty(tag);
        String ext = this.getFileExtension();
        String vText = version.toString();
        String dtd = String.valueOf(tag) + "-" + vText + "." + ext;
        return dtd;
    }

    public ApplicationDTDResourceHelper(T application) {
        super(application, ApplicationResourceType.DTD);
    }
}

