/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applicationmanager.resourcehelpers;

import csbase.client.applicationmanager.ApplicationException;
import csbase.client.applicationmanager.ApplicationManager;
import csbase.client.applicationmanager.ApplicationType;
import csbase.client.applicationmanager.resourcehelpers.PreferredAppDialog;
import csbase.client.csdk.v1_0.application.CSDKApplication;
import csbase.client.desktop.DesktopPref;
import csbase.client.preferences.PreferenceCategory;
import csbase.client.preferences.PreferenceManager;
import csbase.client.preferences.types.PVMap;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.ClientProjectFile;
import csbase.logic.ProjectFileType;
import java.awt.Window;
import java.util.List;
import tecgraf.javautils.core.lng.LNG;

public class ApplicationUtils {
    private static PreferenceManager pm = PreferenceManager.getInstance();
    private static ApplicationManager am = ApplicationManager.getInstance();

    public static String getPreferredApp(Window owner, ClientProjectFile file) {
        ProjectFileType fileType = ProjectFileType.getFileType((String)file.getType());
        String appId = ApplicationUtils.getPreferredAppFromFileType(owner, fileType);
        return appId;
    }

    public static String getPreferredAppFromFileType(Window owner, ProjectFileType fileType) {
        String fileTypeCode = fileType.getCode();
        List<String> apps = am.getApplicationsFromType(fileTypeCode);
        if (apps == null) {
            String title = ApplicationUtils.getString("unsupported.type.title");
            String fileTypeDesc = fileType.getDescription();
            String err = String.valueOf(ApplicationUtils.getString("unsupported.type.msg")) + fileTypeDesc;
            StandardErrorDialogs.showErrorDialog(owner, title, err);
            return null;
        }
        if (apps.size() == 1) {
            return apps.get(0);
        }
        PreferenceCategory root = pm.loadPreferences();
        PreferenceCategory pc = root.getCategory(DesktopPref.class);
        PVMap pv = (PVMap)pc.getPreference(DesktopPref.FILE_TYPE_TO_APP);
        String appId = pv.get(fileTypeCode);
        if (appId == null) {
            PreferredAppDialog dialog = new PreferredAppDialog(owner, apps, fileTypeCode, true);
            dialog.setVisible(true);
            appId = dialog.getSelectedApp();
            if (appId != null && dialog.toSave()) {
                pv.put(fileTypeCode, appId);
                PreferenceManager.getInstance().savePreferences();
            }
        }
        return appId;
    }

    public static void runPreferredApp(Window owner, ClientProjectFile file) throws ApplicationException {
        if (file == null) {
            throw new IllegalArgumentException("file n\u00e3o pode ser nulo.");
        }
        String appId = ApplicationUtils.getPreferredApp(owner, file);
        ApplicationUtils.runApp(appId, owner, file);
    }

    public static void runApp(String appId, Window owner, ClientProjectFile file) throws ApplicationException {
        Object app;
        if (file == null) {
            throw new IllegalArgumentException("file n\u00e3o pode ser nulo.");
        }
        if (appId != null && (app = ApplicationManager.getInstance().runApplication(appId)) != null) {
            if (app instanceof CSDKApplication) {
                ((ApplicationType)app).sendMessage("PROJECT_FILE_PATH", file.getPath(), null);
            } else {
                ((ApplicationType)app).sendMessage("PROJECT_FILE", file, null);
            }
        }
    }

    private static String getString(String key) {
        return LNG.get((String)("ApplicationUtils." + key));
    }
}

