/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications;

import csbase.client.applications.Application;
import csbase.client.applications.ApplicationFrame;
import csbase.client.desktop.LocalTask;
import javax.swing.ImageIcon;

public abstract class ApplicationTask<R>
extends LocalTask<R> {
    private final Application application;
    private String message;
    private ImageIcon image;

    public final void setMessage(String message) {
        this.message = message;
    }

    public final void setImage(ImageIcon image) {
        this.image = image;
    }

    @Override
    protected void handleError(Exception exception) {
        if (!this.application.handleError(exception)) {
            super.handleError(exception);
        }
    }

    public final Application getApplication() {
        return this.application;
    }

    public final boolean execute() {
        ApplicationFrame frame = this.application.getApplicationFrame();
        return this.execute(frame, this.application.getName(), this.message);
    }

    public final boolean executeTask() {
        return this.execute(this.application.getApplicationFrame(), this.application.getName(), this.message, 30, 0, true, true, this.image);
    }

    public ApplicationTask(Application app) {
        this.application = app;
        this.setMessage(String.valueOf(app.getName()) + "...");
    }

    public ApplicationTask(Application app, String msg) {
        this(app);
        this.setMessage(msg);
    }

    public ApplicationTask(Application app, String msg, ImageIcon img) {
        this(app);
        this.setMessage(msg);
        this.setImage(img);
    }

    protected abstract void performTask() throws Exception;
}

