/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.algorithmsmanager.actions;

import csbase.client.applications.algorithmsmanager.actions.CommonVersionAction;
import csbase.client.applications.algorithmsmanager.dialogs.AlgorithmVersionInfoPanel;
import csbase.client.desktop.LocalTask;
import csbase.client.desktop.RemoteTask;
import csbase.client.externalresources.ExternalResources;
import csbase.client.externalresources.LocalFile;
import csbase.client.externalresources.StandaloneLocalFile;
import csbase.client.externalresources.ZipLocalFile;
import csbase.client.remote.srvproxies.AlgorithmManagementProxy;
import csbase.client.util.ClientUtilities;
import csbase.client.util.SingletonFileChooser;
import csbase.client.util.StandardErrorDialogs;
import csbase.exception.CSBaseException;
import csbase.logic.SyncRemoteFileChannel;
import csbase.remote.ClientRemoteLocator;
import csbase.util.FileSystemUtils;
import csbase.util.Unzip;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.rmi.RemoteException;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import javax.swing.ImageIcon;
import tecgraf.ftc.common.logic.RemoteFileChannelInfo;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;

public class VersionImportAction
extends CommonVersionAction {
    private int selectionMode;
    private boolean multiSelectionEnabled;

    public VersionImportAction(AlgorithmVersionInfoPanel versionInfoPanel, ImageIcon icon) {
        super(versionInfoPanel, icon);
        this.setSelectionMode(2);
        this.multiSelectionEnabled = false;
        this.setEnabled(true);
    }

    @Override
    protected void handleVersionOperation() {
        if (this.getSelectedAlgorithm() == null) {
            return;
        }
        if (FileSystemUtils.canRead()) {
            this.fileSystemUpload();
        } else {
            this.appletUpload();
        }
    }

    public void setSelectionMode(int selectionMode) {
        this.selectionMode = selectionMode;
    }

    public int getSelectionMode() {
        return this.selectionMode;
    }

    protected RemoteFileChannelInfo prepareUpload(String filePath) throws RemoteException {
        if (this.getSelectedAlgorithm() == null) {
            return null;
        }
        return ClientRemoteLocator.algorithmService.prepareUploadVersionPack((Object)this.getSelectedAlgorithm().getId(), filePath);
    }

    private void fileSystemUpload() {
        File[] sourceFiles = this.getSourceFiles();
        if (!this.validateFiles(sourceFiles)) {
            return;
        }
        LocalFile[] localFiles = this.createLocalFiles(sourceFiles);
        final ArrayList<RequestTransfer> requests = new ArrayList<RequestTransfer>();
        LocalFile[] localFileArray = localFiles;
        int n = localFiles.length;
        int n2 = 0;
        while (n2 < n) {
            LocalFile sourceFile = localFileArray[n2];
            RemoteFileChannelInfo requestInfo = this.getRequestInfo(sourceFile);
            if (requestInfo != null) {
                requests.add(new RequestTransfer(sourceFile, requestInfo));
            }
            ++n2;
        }
        LocalTask<Void> task = new LocalTask<Void>(){

            protected void performTask() throws Exception {
                for (RequestTransfer request : requests) {
                    request.transfer();
                }
            }

            @Override
            protected void handleError(Exception error) {
                if (error instanceof IOException) {
                    error.printStackTrace();
                    StandardDialogs.showErrorDialog((Component)VersionImportAction.this.getWindow(), (String)VersionImportAction.this.getName(), (String)LNG.get((String)"algomanager.error.upload_fatal"));
                    return;
                }
                super.handleError(error);
            }
        };
        String waitMsg = LNG.get((String)"algomanager.msg.upload_wait");
        task.execute(this.getWindow(), this.getName(), waitMsg, false, true);
    }

    protected void appletUpload() {
        new ImportVersionDialog().show();
    }

    private File[] getSourceFiles() {
        SingletonFileChooser chooser = SingletonFileChooser.getInstance();
        chooser.setFileSelectionMode(this.getSelectionMode());
        chooser.setMultiSelectionEnabled(this.multiSelectionEnabled);
        int returnVal = chooser.showOpenDialog(this.getWindow());
        if (returnVal == 1) {
            return new File[0];
        }
        if (this.multiSelectionEnabled) {
            return chooser.getSelectedFiles();
        }
        return new File[]{chooser.getSelectedFile()};
    }

    private boolean validateFiles(File[] files) {
        return files.length > 0 && this.validateFileExists(files) && this.validateZip(files) && this.validateFileName(files);
    }

    private LocalFile[] createLocalFiles(File[] files) {
        try {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    try {
                        String fileName = String.format("%s.zip", file.getParentFile().getName());
                        return new LocalFile[]{new ZipLocalFile(fileName, files)};
                    }
                    catch (OutOfMemoryError e) {
                        String fatalErrorMsg = LNG.get((String)"algomanager.error.upload_fatal.outOfMemory");
                        StandardErrorDialogs.showErrorDialog(this.getWindow(), this.getName(), fatalErrorMsg, e);
                        return new LocalFile[0];
                    }
                    catch (IOException e) {
                        String fatalErrorMsg = LNG.get((String)"algomanager.error.upload_fatal.io");
                        StandardErrorDialogs.showErrorDialog(this.getWindow(), this.getName(), fatalErrorMsg, e);
                        return new LocalFile[0];
                    }
                    catch (Exception e) {
                        String fatalErrorMsg = LNG.get((String)"algomanager.error.upload_fatal");
                        StandardErrorDialogs.showErrorDialog(this.getWindow(), this.getName(), fatalErrorMsg, e);
                        return new LocalFile[0];
                    }
                }
                ++n2;
            }
            ArrayList<StandaloneLocalFile> sourceFiles = new ArrayList<StandaloneLocalFile>();
            File[] fileArray2 = files;
            int n3 = files.length;
            n = 0;
            while (n < n3) {
                File selFile = fileArray2[n];
                if (selFile != null) {
                    StandaloneLocalFile standAloneFile = new StandaloneLocalFile(selFile);
                    sourceFiles.add(standAloneFile);
                }
                ++n;
            }
            return sourceFiles.toArray(new LocalFile[sourceFiles.size()]);
        }
        catch (AccessControlException ex1) {
            String fatalErrorMsg = LNG.get((String)"algomanager.error.upload_fatal");
            if (!ExternalResources.getInstance().isEnabled()) {
                StandardErrorDialogs.showErrorDialog(this.getWindow(), this.getName(), fatalErrorMsg);
                return null;
            }
            try {
                return ExternalResources.getInstance().openMultiFileDialog(".", null);
            }
            catch (CSBaseException ex2) {
                StandardErrorDialogs.showErrorDialog(this.getWindow(), this.getName(), fatalErrorMsg, ex2);
                return null;
            }
            catch (IOException ex3) {
                StandardErrorDialogs.showErrorDialog(this.getWindow(), this.getName(), LNG.get((String)"algomanager.error.upload_io"), ex3);
                return null;
            }
        }
    }

    private RemoteFileChannelInfo getRequestInfo(LocalFile file) {
        String fileName;
        try {
            fileName = file.getName();
        }
        catch (IOException e) {
            StandardErrorDialogs.showErrorDialog(this.getWindow(), this.getName(), LNG.get((String)"algomanager.error.upload_io"), e);
            return null;
        }
        RemoteTask<RemoteFileChannelInfo> prepareUploadTask = new RemoteTask<RemoteFileChannelInfo>(){

            protected void performTask() throws Exception {
                this.setResult(VersionImportAction.this.prepareUpload(fileName));
            }
        };
        String waitMsg = LNG.get((String)"algomanager.msg.upload_wait");
        if (!prepareUploadTask.execute(this.getWindow(), this.getName(), waitMsg, false, true)) {
            return null;
        }
        return (RemoteFileChannelInfo)prepareUploadTask.getResult();
    }

    private boolean validateFileExists(File[] files) {
        ArrayList<File> invalidFiles = new ArrayList<File>();
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (!file.exists()) {
                invalidFiles.add(file);
            }
            ++n2;
        }
        if (invalidFiles.size() > 0) {
            StringBuilder invalidFilesList = new StringBuilder();
            for (File file : invalidFiles) {
                invalidFilesList.append(String.format(LNG.get((String)"algomanager.error.upload_files_not_found.files.list"), file.getName()));
            }
            StandardErrorDialogs.showErrorDialog(this.getWindow(), this.getName(), String.format(LNG.get((String)"algomanager.error.upload_files_not_found"), invalidFilesList.toString()));
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean validateZip(File[] files) {
        try {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            block3: while (true) {
                ZipEntry entry;
                String fileName;
                if (n2 >= n) {
                    return true;
                }
                File file = fileArray[n2];
                if (!file.getName().toLowerCase().endsWith("zip")) {
                    return true;
                }
                Unzip unzipped = new Unzip(file);
                List entries = unzipped.listZipEntries();
                Iterator iterator = entries.iterator();
                do {
                    if (iterator.hasNext()) continue;
                    ++n2;
                    continue block3;
                } while (ClientUtilities.isValidFileName(fileName = (entry = (ZipEntry)iterator.next()).getName().replaceAll("^(.*/)?([^/]+)/?$", "$2")));
                break;
            }
            StandardErrorDialogs.showErrorDialog(this.getWindow(), this.getName(), LNG.get((String)"UTIL_NAME_CHARACTER_ERROR"));
            return false;
        }
        catch (IOException e) {
            StandardErrorDialogs.showErrorDialog(this.getWindow(), this.getName(), LNG.get((String)"algomanager.error.upload_io"), e);
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            StandardErrorDialogs.showErrorDialog(this.getWindow(), this.getName(), LNG.get((String)"UTIL_NAME_CHARACTER_ERROR"));
            return false;
        }
    }

    private boolean validateFileName(File ... files) {
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (!ClientUtilities.isValidFileName(file.getName())) {
                StandardErrorDialogs.showErrorDialog(this.getWindow(), this.getName(), LNG.get((String)"UTIL_NAME_CHARACTER_ERROR"));
                return false;
            }
            if (file.isDirectory() && !this.validateFileName(file.listFiles())) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private class ImportVersionDialog {
        private ImportVersionDialog() {
        }

        public void show() {
            if (VersionImportAction.this.getSelectedAlgorithm() == null) {
                return;
            }
            if (ExternalResources.getInstance().isEnabled()) {
                String address = AlgorithmManagementProxy.getVersionURL(VersionImportAction.this.getSelectedAlgorithm().getId(), VersionImportAction.this.getWindow());
                if (address == null) {
                    return;
                }
                try {
                    URL url = new URL(address);
                    ExternalResources.getInstance().showDocument(url);
                }
                catch (Exception e) {
                    StandardErrorDialogs.showErrorDialog(VersionImportAction.this.getWindow(), LNG.get((String)"algomanager.title.error"), LNG.get((String)"PRJ_PROJECT_FILE_UPLOAD_IO_ERROR"), e);
                }
            } else {
                StandardDialogs.showInfoDialog((Component)VersionImportAction.this.getWindow(), (String)LNG.get((String)"algomanager.title.error"), (Object)LNG.get((String)"algomanager.error.upload_not_available"));
            }
        }
    }

    static class RequestTransfer {
        LocalFile file;
        RemoteFileChannelInfo info;

        RequestTransfer(LocalFile file, RemoteFileChannelInfo info) {
            this.file = file;
            this.info = info;
        }

        void transfer() throws Exception {
            SyncRemoteFileChannel channel = new SyncRemoteFileChannel(this.info.getIdentifier(), this.info.isWritable(), this.info.getHost(), this.info.getPort(), this.info.getKey());
            channel.open(!this.info.isWritable());
            InputStream inputStream = this.file.getInputStream();
            channel.syncTransferFrom(inputStream, 0L, this.file.getLength());
            inputStream.close();
            channel.close();
        }
    }
}

