/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.algorithmsmanager.dialogs;

import csbase.client.algorithms.ShowHistoryAction;
import csbase.client.applications.algorithmsmanager.AlgorithmsManager;
import csbase.client.applications.algorithmsmanager.dialogs.AlgorithmEditDataPanel;
import csbase.client.applications.algorithmsmanager.dialogs.AlgorithmStaticInfoPanel;
import csbase.client.applications.algorithmsmanager.dialogs.CommonInfoEditPanel;
import csbase.client.applications.algorithmsmanager.models.AlgorithmListItem;
import csbase.client.remote.srvproxies.AlgorithmManagementProxy;
import csbase.client.util.DateTableCellRenderer;
import csbase.logic.algorithms.HistoryProvider;
import csbase.logic.algorithms.HistoryRecord;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.io.File;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SortOrder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import tecgraf.javautils.core.io.FileUtils;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.table.SortableTable;

public class AlgorithmHistoryInfoPanel
extends CommonInfoEditPanel {
    private AlgorithmStaticInfoPanel algorithmHeaderPanel;
    private HistoryProvider historyProvider;
    private JPanel mainPanel;
    private JPanel historyPanel;

    public AlgorithmHistoryInfoPanel(AlgorithmEditDataPanel algoPane) {
        super(algoPane);
        this.showOperationButtons(false);
    }

    private AlgorithmEditDataPanel getAlgorithmEditDataPanel() {
        return (AlgorithmEditDataPanel)this.getEditPanel();
    }

    private AlgorithmListItem getSelectedAlgorithm() {
        return this.getAlgorithmEditDataPanel().getSelectedAlgorithm();
    }

    @Override
    public void initializeData() {
        if (this.getSelectedAlgorithm() == null) {
            return;
        }
        this.algorithmHeaderPanel.setSelectedAlgorithm(this.getSelectedAlgorithm());
        this.updateHistoryPanel();
    }

    private void updateHistoryPanel() {
        this.mainPanel.remove(this.historyPanel);
        this.historyPanel = this.getHistoryPanel();
        this.mainPanel.add((Component)this.historyPanel, new GBC(0, 1).both().west().insets(0, 0, 0, 0));
        this.mainPanel.revalidate();
        this.mainPanel.repaint();
    }

    @Override
    protected JPanel buildMainInfoPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel(new GridBagLayout());
            this.algorithmHeaderPanel = new AlgorithmStaticInfoPanel((AlgorithmsManager)this.getApplication());
            this.historyPanel = this.getHistoryPanel();
            this.mainPanel.add((Component)this.algorithmHeaderPanel, new GBC(0, 0).horizontal().west().insets(0, 0, 0, 0));
            this.mainPanel.add((Component)this.historyPanel, new GBC(0, 1).both().west().insets(0, 0, 0, 0));
        }
        return this.mainPanel;
    }

    private JPanel getHistoryPanel() {
        this.historyPanel = new JPanel(new GridBagLayout());
        this.historyProvider = new AlgorithmHistory();
        List rows = this.historyProvider.getHistory();
        if (rows == null) {
            String message = this.getString("AlgorithmHistoryInfoPanel.msg.error.load.history");
            ((AlgorithmsManager)this.getAlgorithmEditDataPanel().getApplication()).showError(message);
            rows = Collections.emptyList();
        }
        this.historyPanel.add((Component)new JScrollPane(this.makeTable(rows)), new GBC(0, 0).both().west().insets(5, 5, 5, 5));
        return this.historyPanel;
    }

    @Override
    protected void apply() {
    }

    @Override
    protected void cancel() {
    }

    @Override
    public void setDataChanged() {
    }

    private JTable makeTable(List<?> history) {
        HistoryTableModel m = new HistoryTableModel(history);
        SortableTable table = new SortableTable((TableModel)m);
        table.sort(0, SortOrder.DESCENDING);
        table.setDefaultRenderer(Date.class, (TableCellRenderer)new DateTableCellRenderer());
        table.adjustColumnWidth();
        return table;
    }

    @Override
    protected String getTitle() {
        return this.getString("AlgorithmHistoryInfoPanel.tab.history");
    }

    @Override
    public boolean wasModified() {
        return false;
    }

    private class AlgorithmHistory
    implements HistoryProvider {
        private AlgorithmHistory() {
        }

        public List<?> getHistory() {
            if (AlgorithmHistoryInfoPanel.this.getSelectedAlgorithm() == null) {
                return new Vector();
            }
            String repositoryName = LNG.get((String)"algomanager.tree.root");
            String[] spath = new String[]{repositoryName, AlgorithmHistoryInfoPanel.this.getSelectedAlgorithm().getName()};
            return AlgorithmManagementProxy.retrieveHistory(spath);
        }

        public String getName() {
            if (AlgorithmHistoryInfoPanel.this.getSelectedAlgorithm() == null) {
                return "";
            }
            String repositoryName = AlgorithmHistoryInfoPanel.this.getString("AlgorithmHistoryInfoPanel.algorithm.repository.name");
            return String.valueOf(repositoryName) + File.separator + AlgorithmHistoryInfoPanel.this.getSelectedAlgorithm().getName();
        }
    }

    private class HistoryTableModel
    extends AbstractTableModel {
        private List<?> recordList;
        private String[] columnNames = new String[]{LNG.get((String)(String.valueOf(ShowHistoryAction.class.getName()) + ".dateColumn")), LNG.get((String)(String.valueOf(ShowHistoryAction.class.getName()) + ".pathColumn")), LNG.get((String)(String.valueOf(ShowHistoryAction.class.getName()) + ".loginColumn")), LNG.get((String)(String.valueOf(ShowHistoryAction.class.getName()) + ".nameColumn")), LNG.get((String)(String.valueOf(ShowHistoryAction.class.getName()) + ".descriptionColumn"))};
        private Class<?>[] columnClasses = new Class[]{Date.class, String.class, String.class, String.class, String.class};

        public HistoryTableModel(List<?> recordList) {
            this.recordList = recordList;
        }

        @Override
        public int getRowCount() {
            return this.recordList.size();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            HistoryRecord rec = (HistoryRecord)this.recordList.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return rec.getDate();
                }
                case 1: {
                    return FileUtils.joinPath((String[])rec.getDirPath());
                }
                case 2: {
                    return rec.getUserLogin();
                }
                case 3: {
                    return rec.getUserName();
                }
                case 4: {
                    return rec.getDescription();
                }
            }
            return null;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.columnNames[columnIndex];
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return this.columnClasses[columnIndex];
        }
    }
}

