/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.algorithmsmanager.dialogs;

import csbase.client.applications.algorithmsmanager.AlgorithmsManager;
import csbase.client.applications.algorithmsmanager.DataPropertiesListener;
import csbase.client.applications.algorithmsmanager.actions.VersionCreateAction;
import csbase.client.applications.algorithmsmanager.actions.VersionDuplicateAction;
import csbase.client.applications.algorithmsmanager.actions.VersionExportAction;
import csbase.client.applications.algorithmsmanager.actions.VersionImportAction;
import csbase.client.applications.algorithmsmanager.actions.VersionRemoveAction;
import csbase.client.applications.algorithmsmanager.dialogs.AlgorithmEditDataPanel;
import csbase.client.applications.algorithmsmanager.dialogs.AlgorithmStaticInfoPanel;
import csbase.client.applications.algorithmsmanager.dialogs.CommonInfoEditPanel;
import csbase.client.applications.algorithmsmanager.dialogs.VersionPanel;
import csbase.client.applications.algorithmsmanager.dialogs.VersionTreeView;
import csbase.client.applications.algorithmsmanager.models.AlgorithmListItem;
import csbase.client.applications.algorithmsmanager.versiontree.VersionNode;
import csbase.client.applications.algorithmsmanager.versiontree.VersionTree;
import csbase.client.applications.algorithmsmanager.versiontree.VersionTreeNode;
import csbase.client.remote.srvproxies.AlgorithmManagementProxy;
import csbase.client.util.ClientUtilities;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.tree.TreePath;
import tecgraf.javautils.gui.GBC;

public class AlgorithmVersionInfoPanel
extends CommonInfoEditPanel
implements DataPropertiesListener {
    private VersionPanel versionEditPanel;
    private VersionTreeView versionTreeView;
    private JPanel versionTreePanel;
    private JPanel mainPanel;
    private JPanel actionsPanel;
    private AlgorithmStaticInfoPanel algorithmHeaderPanel;
    private VersionImportAction importVersionAction;
    private VersionCreateAction createVersionAction;
    private VersionDuplicateAction duplicateVersionAction;
    private VersionRemoveAction removeVersionAction;
    private VersionExportAction exportVersionAction;
    private boolean isEditing;

    public AlgorithmVersionInfoPanel(AlgorithmEditDataPanel algoPane) {
        super(algoPane);
    }

    private AlgorithmEditDataPanel getAlgorithmEditDataPanel() {
        return (AlgorithmEditDataPanel)this.getEditPanel();
    }

    public AlgorithmListItem getSelectedAlgorithmItem() {
        return this.getAlgorithmEditDataPanel().getSelectedAlgorithm();
    }

    @Override
    public void initializeData() {
        if (this.getSelectedAlgorithmItem() == null) {
            return;
        }
        if (!this.isEditing) {
            this.algorithmHeaderPanel.setSelectedAlgorithm(this.getSelectedAlgorithmItem());
            this.updateVersionTreePanel();
            this.versionEditPanel.initialize(this.getSelectedAlgorithmItem(), null);
            this.versionTreeView.setCurrentNode();
        }
        this.changeOperationsState(this.isEditing);
    }

    private void updateVersionTreePanel() {
        this.mainPanel.remove(this.versionTreePanel);
        this.mainPanel.remove(this.actionsPanel);
        this.versionTreePanel = this.getVersionTreePanel();
        this.actionsPanel = this.getVersionButtonPanel();
        this.mainPanel.add((Component)this.versionTreePanel, new GBC(0, 1).both().west().insets(0, 0, 0, 0));
        this.mainPanel.add((Component)this.actionsPanel, new GBC(1, 1).none().west().insets(0, 0, 0, 0));
        if (this.getSelectedAlgorithmItem() != null) {
            this.getVersionTreeView().initializeVersionTree(this.getSelectedAlgorithmItem().getItem());
        }
        this.mainPanel.revalidate();
        this.mainPanel.repaint();
    }

    @Override
    protected JPanel buildMainInfoPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel(new GridBagLayout());
            this.algorithmHeaderPanel = new AlgorithmStaticInfoPanel((AlgorithmsManager)this.getApplication());
            this.versionTreePanel = this.getVersionTreePanel();
            this.actionsPanel = this.getVersionButtonPanel();
            this.versionEditPanel = this.getVersionInfoPanel();
            this.mainPanel.add((Component)this.algorithmHeaderPanel, new GBC(0, 0).horizontal().gridwidth(2).west().insets(0, 0, 0, 0));
            this.mainPanel.add((Component)this.versionTreePanel, new GBC(0, 1).both().west().insets(0, 0, 0, 0));
            this.mainPanel.add((Component)this.actionsPanel, new GBC(1, 1).none().west().insets(0, 0, 0, 0));
            this.mainPanel.add((Component)this.versionEditPanel, new GBC(0, 2).horizontal().gridwidth(2).west().insets(0, 0, 0, 0));
        }
        return this.mainPanel;
    }

    private JPanel getVersionButtonPanel() {
        if (this.getSelectedAlgorithmItem() == null) {
            return new JPanel();
        }
        this.actionsPanel = new JPanel(new GridBagLayout());
        this.createVersionAction = new VersionCreateAction(this, null);
        this.duplicateVersionAction = new VersionDuplicateAction(this, null);
        this.removeVersionAction = new VersionRemoveAction(this, null);
        this.importVersionAction = new VersionImportAction(this, null);
        this.exportVersionAction = new VersionExportAction(this, null);
        JButton addButton = new JButton(this.createVersionAction);
        JButton duplicateButton = new JButton(this.duplicateVersionAction);
        JButton removeButton = new JButton(this.removeVersionAction);
        JButton importButton = new JButton(this.importVersionAction);
        JButton exportButton = new JButton(this.exportVersionAction);
        this.actionsPanel.add((Component)addButton, new GBC(0, 0).horizontal().west().insets(5, 15, 5, 15));
        this.actionsPanel.add((Component)importButton, new GBC(0, 1).horizontal().west().insets(5, 15, 5, 15));
        this.actionsPanel.add((Component)exportButton, new GBC(0, 2).horizontal().west().insets(5, 15, 5, 15));
        this.actionsPanel.add((Component)duplicateButton, new GBC(0, 3).horizontal().west().insets(5, 15, 5, 15));
        this.actionsPanel.add((Component)removeButton, new GBC(0, 4).horizontal().west().insets(5, 15, 5, 15));
        ClientUtilities.adjustEqualSizes(addButton, duplicateButton, removeButton, importButton);
        return this.actionsPanel;
    }

    private VersionPanel getVersionInfoPanel() {
        if (this.versionEditPanel == null) {
            this.versionEditPanel = new VersionPanel((AlgorithmsManager)this.getApplication(), this.getSelectedAlgorithmItem());
            this.versionEditPanel.addVersionListener(this);
            this.versionEditPanel.setEnabled(false);
            this.versionEditPanel.enableEdition(true);
        }
        return this.versionEditPanel;
    }

    private JPanel getVersionTreePanel() {
        if (this.getSelectedAlgorithmItem() == null) {
            return new JPanel();
        }
        this.versionTreePanel = this.getVersionTreeView().getVersionTreePanel();
        return this.versionTreePanel;
    }

    private VersionTreeView getVersionTreeView() {
        if (this.versionTreeView == null && this.getSelectedAlgorithmItem() != null) {
            this.versionTreeView = new VersionTreeView(this, this.getSelectedAlgorithmItem().getItem());
        }
        return this.versionTreeView;
    }

    @Override
    protected void apply() {
        this.isEditing = false;
        if (!this.saveInfo()) {
            return;
        }
        this.changeOperationsState(false);
    }

    private boolean saveInfo() {
        if (this.versionEditPanel.validateProperties()) {
            this.updateVersion();
            return true;
        }
        return false;
    }

    @Override
    protected void cancel() {
        if (this.confirmCancelling()) {
            this.initializeData();
            this.changeOperationsState(false);
        }
    }

    @Override
    public void setDataChanged() {
        this.isEditing = false;
        this.changeOperationsState(this.isEditing);
    }

    private boolean confirmCancelling() {
        int confirm = ((AlgorithmsManager)this.getApplication()).showOptionDialog(this.getString("AlgorithmVersionInfoPanel.msg.cancel.confirm"), new String[]{this.getString("AlgorithmVersionInfoPanel.msg.cancel.confirm.yes"), this.getString("AlgorithmVersionInfoPanel.msg.cancel.confirm.no")});
        if (confirm == 0) {
            this.isEditing = false;
            return true;
        }
        return false;
    }

    @Override
    public boolean wasModified() {
        return this.versionEditPanel.wasModified();
    }

    @Override
    public void propertiesChanged(boolean wasModified) {
        this.isEditing = wasModified;
        this.changeOperationsState(wasModified);
    }

    private void updateVersion() {
        if (this.getSelectedAlgorithmItem() == null) {
            return;
        }
        AlgorithmInfo algoInfo = this.getSelectedAlgorithmItem().getItem();
        String name = algoInfo.getName();
        AlgorithmVersionInfo versionInfo = this.getSelectedVersion();
        algoInfo = AlgorithmManagementProxy.changeVersionProperties(name, versionInfo.getId(), this.versionEditPanel.getProperties(), this.getWindow());
        String dialogTitle = this.getString("AlgorithmVersionInfoPanel.title.algo_properties");
        if (algoInfo == null) {
            String title = MessageFormat.format(this.getString("AlgorithmVersionInfoPanel.title.error"), dialogTitle);
            StandardErrorDialogs.showErrorDialog(this.getWindow(), title, MessageFormat.format(this.getString("AlgorithmVersionInfoPanel.error.update"), name));
            return;
        }
    }

    public AlgorithmVersionInfo getSelectedVersion() {
        List<AlgorithmVersionInfo> versions = this.getSelectedVersions();
        if (versions.isEmpty()) {
            return null;
        }
        return versions.get(0);
    }

    public List<AlgorithmVersionInfo> getSelectedVersions() {
        ArrayList<AlgorithmVersionInfo> versions = new ArrayList<AlgorithmVersionInfo>();
        TreePath[] selectionPaths = this.versionTreeView.getVersionTree().getSelectionPaths();
        if (selectionPaths != null) {
            TreePath[] treePathArray = selectionPaths;
            int n = selectionPaths.length;
            int n2 = 0;
            while (n2 < n) {
                TreePath path = treePathArray[n2];
                Object node = path.getLastPathComponent();
                if (node instanceof VersionNode) {
                    VersionNode versionNode = (VersionNode)node;
                    AlgorithmVersionInfo info = (AlgorithmVersionInfo)versionNode.getUserObject();
                    versions.add(info);
                }
                ++n2;
            }
        }
        return versions;
    }

    private Window getWindow() {
        return ((AlgorithmsManager)this.getAlgorithmEditDataPanel().getApplication()).getApplicationFrame();
    }

    @Override
    protected String getTitle() {
        return this.getString("AlgorithmVersionInfoPanel.tab.versions");
    }

    public void verifyAndChangeButtonsState() {
        this.enableAction(this.createVersionAction, true);
        this.enableAction(this.duplicateVersionAction, this.getSelectedVersions().size() == 1);
        this.enableAction(this.removeVersionAction, !this.getSelectedVersions().isEmpty());
        this.enableAction(this.importVersionAction, true);
        this.enableAction(this.exportVersionAction, this.getSelectedVersions().size() == 1);
    }

    protected void enableAction(Action opAction, boolean state) {
        if (opAction != null) {
            opAction.setEnabled(state);
        }
    }

    public int getSelectedRow() {
        VersionTree dataTree = this.versionTreeView.getVersionTree();
        int[] selectionRows = dataTree.getSelectionRows();
        if (selectionRows != null && selectionRows.length > 0) {
            return selectionRows[0];
        }
        return 0;
    }

    public void enableVersionEditPanel(boolean state) {
        this.versionEditPanel.enableEdition(state);
    }

    public boolean confirmSelectionChanged() {
        return !this.isEditing || this.confirmCancelling();
    }

    public void initVersionNodeEdition(VersionTreeNode versionNode) {
        this.isEditing = false;
        this.versionEditPanel.initialize(this.getSelectedAlgorithmItem(), versionNode);
        this.verifyAndChangeButtonsState();
    }

    public void handleAlgorithmUpdated(AlgorithmInfo algoInfo) {
        if (algoInfo != null) {
            this.versionTreeView.handleAlgorithmUpdated(algoInfo);
        }
    }
}

