/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.algorithmsmanager.dialogs;

import csbase.client.applications.AbstractSimpleApplicationPanel;
import csbase.client.applications.algorithmsmanager.AlgorithmsManager;
import csbase.client.applications.algorithmsmanager.AlgorithmsManagerAdapter;
import csbase.client.applications.algorithmsmanager.actions.AlgorithmsManagerAction;
import csbase.client.applications.algorithmsmanager.dialogs.CommonInfoEditPanel;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.Category;
import csbase.logic.algorithms.CategorySet;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.text.MessageFormat;
import java.util.List;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import tecgraf.javautils.gui.GBC;

public abstract class CommonEditTabbedPanel
extends AbstractSimpleApplicationPanel<AlgorithmsManager> {
    private AlgorithmsManagerAction action;
    private JTabbedPane editTabbedPanel;

    public CommonEditTabbedPanel(AlgorithmsManagerAction action) {
        super((AlgorithmsManager)action.getApplication());
        this.action = action;
        this.buildPanel();
        this.buildAdditionalInfoPanel();
        this.editTabbedPanel.setSelectedIndex(0);
        this.setInfoPanelTitle(this.getSelectedInfoPanel(), this.getSelectedInfoPanel().getTitle());
        ((AlgorithmsManager)action.getApplication()).addAlgorithmsManagerListener(new AlgorithmsManagerAdapter(){

            @Override
            public void categoryUpdated(CategorySet modifiedCategorySet) {
                CommonEditTabbedPanel.this.handleCategoryUpdated(modifiedCategorySet);
            }

            @Override
            public void categoryRemoved(Category category) {
                CommonEditTabbedPanel.this.handleCategoryRemoved(category);
            }

            @Override
            public void categoryCreated(Category category) {
                CommonEditTabbedPanel.this.handleCategoryCreated(category);
            }

            @Override
            public void algorithmUpdated(AlgorithmInfo algoInfo) {
                CommonEditTabbedPanel.this.handleAlgorithmUpdated(algoInfo);
            }

            @Override
            public void algorithmRemoved(AlgorithmInfo algoInfo) {
                CommonEditTabbedPanel.this.handleAlgorithmRemoved(algoInfo);
            }

            @Override
            public void algorithmCreated(AlgorithmInfo algoInfo) {
                CommonEditTabbedPanel.this.handleAlgorithmCreated(algoInfo);
            }
        });
    }

    protected void handleCategoryCreated(Category category) {
    }

    protected void handleCategoryRemoved(Category category) {
    }

    protected void handleCategoryUpdated(CategorySet modifiedCategorySet) {
    }

    protected void handleAlgorithmUpdated(AlgorithmInfo algoInfo) {
    }

    protected void handleAlgorithmCreated(AlgorithmInfo algoInfo) {
    }

    protected void handleAlgorithmRemoved(AlgorithmInfo algoInfo) {
    }

    public AlgorithmsManagerAction getAction() {
        return this.action;
    }

    protected abstract JPanel buildBasicInfoPanel();

    protected abstract void buildAdditionalInfoPanel();

    public abstract void initializeData();

    public abstract boolean confirmDataChanged();

    @Override
    protected void buildPanel() {
        this.editTabbedPanel = new JTabbedPane();
        this.editTabbedPanel.addTab(((AlgorithmsManager)this.getApplication()).getString("CommonEditTabbedPanel.tab.info.basic"), this.buildBasicInfoPanel());
        this.setLayout(new GridBagLayout());
        this.add((Component)this.editTabbedPanel, new GBC(0, 0).both().insets(5, 5, 5, 5));
    }

    public void addInfoPanel(String title, CommonInfoEditPanel panel) {
        this.editTabbedPanel.addTab(title, panel);
        this.revalidate();
    }

    public CommonInfoEditPanel getSelectedInfoPanel() {
        return (CommonInfoEditPanel)this.editTabbedPanel.getSelectedComponent();
    }

    public void setSelectedInfoPanel(CommonInfoEditPanel infoPanel) {
        this.editTabbedPanel.setSelectedComponent(infoPanel);
    }

    public void setInfoPanelTitle(CommonInfoEditPanel panel, String title) {
        int selectedIndex = this.getTabComponentIndex(panel);
        if (selectedIndex != -1) {
            this.editTabbedPanel.setTitleAt(selectedIndex, title);
        }
    }

    private int getTabComponentIndex(CommonInfoEditPanel panel) {
        int i = 0;
        while (i < this.editTabbedPanel.getTabCount()) {
            Component tabPanel = this.editTabbedPanel.getComponentAt(i);
            if (tabPanel != null && tabPanel.equals(panel)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected JPanel buildEmptyPanel() {
        return new JPanel();
    }

    public List<CommonInfoEditPanel> getInfoPanelList() {
        Component[] components;
        Vector<CommonInfoEditPanel> panelList = new Vector<CommonInfoEditPanel>();
        Component[] componentArray = components = this.editTabbedPanel.getComponents();
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            Component component = componentArray[n2];
            if (component instanceof CommonInfoEditPanel) {
                panelList.add((CommonInfoEditPanel)component);
            }
            ++n2;
        }
        return panelList;
    }

    protected String getChangedPanelsDescription() {
        String desc = "<html> <ul> ";
        List<CommonInfoEditPanel> infoPanelList = this.getInfoPanelList();
        for (CommonInfoEditPanel infoPanel : infoPanelList) {
            if (!infoPanel.wasModified()) continue;
            desc = String.valueOf(desc) + "<li>" + infoPanel.getTitle();
        }
        desc = String.valueOf(desc) + "</ul> </html>";
        return desc;
    }

    protected boolean confirmCancelling() {
        String changedPanelsDescription = this.getChangedPanelsDescription();
        String confirmMsg = MessageFormat.format(((AlgorithmsManager)this.getApplication()).getString("CommonEditTabbedPanel.msg.cancel.confirm"), changedPanelsDescription);
        int confirm = ((AlgorithmsManager)this.getApplication()).showOptionDialog(confirmMsg, new String[]{((AlgorithmsManager)this.getApplication()).getString("CommonEditTabbedPanel.msg.cancel.confirm.yes"), ((AlgorithmsManager)this.getApplication()).getString("CommonEditTabbedPanel.msg.cancel.confirm.no")});
        if (confirm == 0) {
            List<CommonInfoEditPanel> infoPanelList = this.getInfoPanelList();
            for (CommonInfoEditPanel infoPanel : infoPanelList) {
                if (!infoPanel.wasModified()) continue;
                infoPanel.setDataChanged();
            }
            return true;
        }
        return false;
    }
}

