/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.algorithmsmanager.dialogs;

import csbase.client.applications.AbstractSimpleApplicationPanel;
import csbase.client.applications.algorithmsmanager.AlgorithmsManager;
import csbase.client.applications.algorithmsmanager.actions.CommonManagementAction;
import csbase.client.applications.algorithmsmanager.dialogs.AlgorithmsManagerSplitComponent;
import csbase.client.applications.algorithmsmanager.dialogs.CommonEditTabbedPanel;
import csbase.client.applications.algorithmsmanager.dialogs.CommonSelectionPanel;
import csbase.client.applications.algorithmsmanager.models.DataInterface;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import tecgraf.javautils.gui.GBC;

public abstract class CommonManagementPanel
extends AbstractSimpleApplicationPanel<AlgorithmsManager> {
    private CommonManagementAction action;
    private AlgorithmsManagerSplitComponent splitComponent;
    private CommonSelectionPanel selectionPanel;
    private CommonEditTabbedPanel editPanel;
    private CommonEditTabbedPanel createPanel;

    public CommonManagementPanel(CommonManagementAction action) {
        super((AlgorithmsManager)action.getApplication());
        this.action = action;
        this.buildPanel();
    }

    public CommonManagementAction getManagementAction() {
        return this.action;
    }

    public CommonSelectionPanel getSelectionPanel() {
        return this.selectionPanel;
    }

    public CommonEditTabbedPanel getEditPanel() {
        if (this.createPanel != null) {
            return this.createPanel;
        }
        if (this.editPanel instanceof CommonEditTabbedPanel) {
            return this.editPanel;
        }
        return null;
    }

    protected JPanel buildEmptyPanel() {
        return new JPanel();
    }

    protected abstract CommonSelectionPanel buildSelectionPanel();

    protected abstract CommonEditTabbedPanel buildEditPanel();

    @Override
    protected void buildPanel() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder((String)this.action.getValue("ShortDescription")));
        this.splitComponent = this.getManageSplitComponent();
        this.add((Component)this.splitComponent.getSplitPanel(), new GBC(0, 0).both().west().insets(5, 5, 5, 5));
    }

    private AlgorithmsManagerSplitComponent getManageSplitComponent() {
        if (this.splitComponent == null) {
            this.selectionPanel = this.buildSelectionPanel();
            this.editPanel = this.buildEditPanel();
            this.splitComponent = new AlgorithmsManagerSplitComponent((AlgorithmsManager)this.getApplication(), this.selectionPanel, this.editPanel);
        }
        return this.splitComponent;
    }

    public void updateEditPanel(boolean showInfo) {
        this.createPanel = null;
        if (this.splitComponent != null) {
            if (!showInfo) {
                this.splitComponent.updateEditPanel(this.buildEmptyPanel());
            } else {
                CommonEditTabbedPanel editPanel = this.getEditPanel();
                this.splitComponent.updateEditPanel(editPanel);
            }
        }
    }

    public void setCreatePanel(CommonEditTabbedPanel createPanel) {
        if (this.splitComponent != null) {
            if (createPanel == null) {
                this.createPanel = null;
                this.splitComponent.updateEditPanel(this.buildEmptyPanel());
            } else {
                this.createPanel = createPanel;
                this.splitComponent.updateEditPanel(createPanel);
                createPanel.initializeData();
            }
        }
    }

    public List<DataInterface> getSelectedDataList() {
        return this.getSelectionPanel().getSelectedDataList();
    }

    public DataInterface getFirstSelectedData() {
        return this.getSelectionPanel().getSelectedData();
    }

    public void updateSelectionPanel(JPanel panel) {
        this.splitComponent.updateSelectionPanel(panel);
    }
}

