/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.algorithmsmanager.models;

import csbase.client.applications.algorithmsmanager.versiontree.VersionTree;
import csbase.client.remote.srvproxies.AlgorithmManagementProxy;
import csbase.logic.algorithms.HistoryProvider;
import csbase.logic.algorithms.HistoryRecord;
import java.awt.Window;
import java.io.File;
import java.text.Collator;
import java.util.Collections;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public abstract class AbstractVersionTreeNode
extends DefaultMutableTreeNode
implements HistoryProvider,
Comparable<MutableTreeNode> {
    private static final JPopupMenu NULL_POPUP_MENU = new JPopupMenu();
    private VersionTree tree;

    public AbstractVersionTreeNode(VersionTree tree, Object userObject) {
        super(userObject);
        this.tree = tree;
    }

    public final VersionTree getTree() {
        return this.tree;
    }

    public final Window getWindow() {
        return this.tree.getOwner();
    }

    public JPopupMenu createPopupMenu() {
        return NULL_POPUP_MENU;
    }

    public boolean allowMultipleSelection(AbstractVersionTreeNode other) {
        return false;
    }

    @Override
    public void add(MutableTreeNode newChild) {
        int index;
        if (newChild != null && newChild.getParent() == this) {
            this.remove(newChild);
        }
        if ((index = this.children == null ? 0 : Collections.binarySearch(this.children, newChild)) < 0) {
            index = -index - 1;
        }
        this.insert(newChild, index);
    }

    public List<HistoryRecord> getHistory() {
        TreeNode[] path = this.getPath();
        String[] spath = new String[path.length];
        int inx = 0;
        while (inx < path.length) {
            TreeNode node = path[inx];
            spath[inx] = node.toString();
            ++inx;
        }
        return AlgorithmManagementProxy.retrieveHistory(spath);
    }

    public String getName() {
        TreeNode[] path;
        StringBuilder name = new StringBuilder();
        TreeNode[] treeNodeArray = path = this.getPath();
        int n = path.length;
        int n2 = 0;
        while (n2 < n) {
            TreeNode node = treeNodeArray[n2];
            name.append(File.separator).append(node.toString());
            ++n2;
        }
        return name.toString();
    }

    @Override
    public int compareTo(MutableTreeNode node) {
        return Collator.getInstance().compare(this.toString(), node.toString());
    }

    public abstract ImageIcon getImageIcon();
}

