/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.algorithmsmanager.versiontree;

import csbase.client.applications.algorithmsmanager.versiontree.AbstractFileInfoNode;
import csbase.client.applications.algorithmsmanager.versiontree.VersionTree;
import csbase.client.applications.algorithmsmanager.versiontree.actions.CopyFile;
import csbase.client.applications.algorithmsmanager.versiontree.actions.ExportExecutableFile;
import csbase.client.applications.algorithmsmanager.versiontree.actions.ImportExecutableFile;
import csbase.client.applications.algorithmsmanager.versiontree.actions.PasteFile;
import csbase.client.applications.algorithmsmanager.versiontree.actions.RemoveExecutableFiles;
import csbase.client.applications.algorithmsmanager.versiontree.actions.VersionWarningActionDecorator;
import csbase.logic.FileInfo;
import csbase.logic.IPathFactory;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.logic.algorithms.ExecutablePathFactory;
import java.awt.datatransfer.DataFlavor;
import java.io.File;
import java.io.Serializable;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.TreeNode;
import tecgraf.javautils.core.lng.LNG;

final class ExecutableFileNode
extends AbstractFileInfoNode {
    public static final DataFlavor DATA_FLAVOR = new DataFlavor(ExecutableFileNode.class, ExecutableFileNode.class.getSimpleName());
    private final String platform;

    public ExecutableFileNode(final VersionTree tree, final AlgorithmVersionInfo version, final String platform, FileInfo file) {
        super(tree, version, file, new AbstractFileInfoNode.IChildrenFactory(){

            @Override
            public AbstractFileInfoNode createNode(FileInfo file) {
                return new ExecutableFileNode(tree, version, platform, file);
            }
        }, true);
        this.platform = platform;
    }

    @Override
    public JPopupMenu createPopupMenu() {
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.add(new JMenuItem(new VersionWarningActionDecorator(new CopyFile(this.getTree(), LNG.get((String)"algomanager.menu.bin_file.copy")))));
        if (this.getFile().isDirectory()) {
            popupMenu.add(new JMenuItem(new VersionWarningActionDecorator(new ImportExecutableFile(this.getTree(), this.getVersion(), this.platform, this.getExecFileDestPath()))));
            popupMenu.add(new JMenuItem(new VersionWarningActionDecorator(new PasteFile(this.getTree(), LNG.get((String)"algomanager.menu.bin_file.paste"), DATA_FLAVOR))));
        }
        popupMenu.add(new JMenuItem(new VersionWarningActionDecorator(new RemoveExecutableFiles(this.getTree(), this.getVersion(), this.platform, this.getSelectedFiles()))));
        if (!this.getFile().isDirectory()) {
            popupMenu.add(new JMenuItem(new VersionWarningActionDecorator(new ExportExecutableFile(this.getTree(), this.getVersion(), this.platform, this.getFile()))));
        }
        return popupMenu;
    }

    private String getExecFileDestPath() {
        boolean found = false;
        StringBuilder name = new StringBuilder();
        TreeNode[] treeNodeArray = this.getPath();
        int n = treeNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeNode node = treeNodeArray[n2];
            if (found) {
                name.append(File.separator).append(node.toString());
            }
            if (node.toString().equals(this.platform)) {
                found = true;
            }
            ++n2;
        }
        return name.toString();
    }

    @Override
    public DataFlavor getDataFlavor() {
        return DATA_FLAVOR;
    }

    @Override
    protected final AbstractFileInfoNode.DataTransferObject createDataTransferObject() {
        return new ExecutableDTO(this);
    }

    @Override
    protected final IPathFactory createSourcePathFactory(AbstractFileInfoNode.DataTransferObject dto) {
        AlgorithmVersionInfo sourceVersion = dto.getVersion();
        String sourcePlatform = ((ExecutableDTO)dto).getPlatformName();
        return new ExecutablePathFactory(sourceVersion, sourcePlatform);
    }

    @Override
    protected final IPathFactory createTargetPathFactory() {
        return new ExecutablePathFactory(this.getVersion(), this.platform);
    }

    public static class ExecutableDTO
    extends AbstractFileInfoNode.DataTransferObject
    implements Serializable {
        private final String platform;

        public ExecutableDTO(ExecutableFileNode node) {
            super(node);
            this.platform = node.platform;
        }

        public String getPlatformName() {
            return this.platform;
        }
    }
}

