/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.algorithmsmanager.versiontree;

import csbase.client.applications.ApplicationImages;
import csbase.client.applications.algorithmsmanager.versiontree.AbstractVersionTreeNode;
import csbase.client.applications.algorithmsmanager.versiontree.Mode;
import csbase.client.applications.algorithmsmanager.versiontree.VersionTreeModel;
import csbase.client.applications.algorithmsmanager.versiontree.VersionTreeRootNode;
import csbase.client.applications.algorithmsmanager.versiontree.datatransfer.VersionTreeTransferHandler;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public final class VersionTree
extends JTree {
    private Window owner;
    private Mode mode;
    private AlgorithmInfo algorithmInfo;
    private Vector<AlgorithmVersionInfo> versions;
    private VersionTreeModel model;
    private Enumeration<TreePath> expandedNodes;
    private Rectangle visibleRectangle;
    private boolean disablePopupMenu = false;

    public VersionTree(Window owner, AlgorithmInfo algorithmInfo) {
        this.owner = owner;
        this.mode = this.getDefaultMode();
        this.algorithmInfo = algorithmInfo;
        this.getSelectionModel().setSelectionMode(4);
        this.initializeTree(algorithmInfo);
        this.setTransferHandler(new VersionTreeTransferHandler());
        this.setDragEnabled(true);
        this.addTreeSelectionListener(new SelectionListener());
        this.addMouseListener(new MouseListener());
        this.setCellRenderer(new CellRenderer());
    }

    public Mode getMode() {
        return this.mode;
    }

    public Window getOwner() {
        return this.owner;
    }

    public boolean contains(String versionName) {
        if (this.model == null || this.model.getRoot() == null) {
            return false;
        }
        return ((VersionTreeRootNode)this.model.getRoot()).getNodeIndex(versionName) >= 0;
    }

    private VersionTreeRootNode createRootNode() {
        VersionTreeRootNode versionRootNode = new VersionTreeRootNode(this, this.loadAlgorithmVersions());
        return versionRootNode;
    }

    private Vector<AlgorithmVersionInfo> loadAlgorithmVersions() {
        if (this.algorithmInfo == null) {
            return null;
        }
        this.versions = this.algorithmInfo.getVersions();
        return this.versions;
    }

    private AbstractVersionTreeNode getSelectedNode(TreePath path) {
        Object tmp;
        if (path != null && AbstractVersionTreeNode.class.isAssignableFrom((tmp = path.getLastPathComponent()).getClass())) {
            return (AbstractVersionTreeNode)tmp;
        }
        return null;
    }

    public Mode getDefaultMode() {
        return Mode.CLASSIC;
    }

    public void replaceAlgoNode(AlgorithmInfo newAlgorithmInfo) {
        this.backupExpandedNodes();
        if (!this.algorithmInfo.equals((Object)newAlgorithmInfo)) {
            return;
        }
        this.algorithmInfo = newAlgorithmInfo;
        this.updateVersionTreeModel(newAlgorithmInfo);
        this.restoreExpandedNodes();
    }

    private void backupExpandedNodes() {
        TreePath rootPath = new TreePath(this.model.getRoot());
        this.expandedNodes = this.getExpandedDescendants(rootPath);
        this.visibleRectangle = this.getVisibleRect();
    }

    /*
     * Unable to fully structure code
     */
    private void restoreExpandedNodes() {
        if (this.expandedNodes != null) ** GOTO lbl7
        return;
lbl-1000:
        // 1 sources

        {
            oldPath = this.expandedNodes.nextElement();
            newPath = this.getNewPath(oldPath);
            if (!this.isCollapsed(newPath)) continue;
            this.expandPath(newPath);
lbl7:
            // 3 sources

            ** while (this.expandedNodes.hasMoreElements())
        }
lbl8:
        // 1 sources

        this.scrollRectToVisible(this.visibleRectangle);
    }

    private TreePath getNewPath(TreePath oldPath) {
        Object[] path = oldPath.getPath();
        if (path.length == 1) {
            return new TreePath(this.model.getRoot());
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.model.getRoot();
        int i = 1;
        while (i < path.length) {
            DefaultMutableTreeNode oldNode = (DefaultMutableTreeNode)path[i];
            Enumeration<TreeNode> children = node.children();
            if (children.equals(DefaultMutableTreeNode.EMPTY_ENUMERATION)) {
                return null;
            }
            DefaultMutableTreeNode childNode = null;
            boolean found = false;
            while (children.hasMoreElements()) {
                childNode = (DefaultMutableTreeNode)children.nextElement();
                if (oldNode.getUserObject() instanceof AlgorithmVersionInfo && childNode.getUserObject() instanceof AlgorithmVersionInfo) {
                    AlgorithmVersionInfo oldVersion = (AlgorithmVersionInfo)oldNode.getUserObject();
                    AlgorithmVersionInfo childVersion = (AlgorithmVersionInfo)childNode.getUserObject();
                    if (!oldVersion.getId().equals((Object)childVersion.getId())) continue;
                    found = true;
                    break;
                }
                if (!childNode.toString().equals(path[i].toString())) continue;
                found = true;
                break;
            }
            if (!found) {
                return null;
            }
            node = childNode;
            ++i;
        }
        return new TreePath(node.getPath());
    }

    private void updateVersionTreeModel(AlgorithmInfo modifiedAlgoInfo) {
        this.algorithmInfo = modifiedAlgoInfo;
        VersionTreeRootNode root = this.createRootNode();
        this.model = new VersionTreeModel(root);
        this.setModel(this.model);
    }

    public void selectNode(int row) {
        this.setSelectionInterval(row, row);
    }

    public void initializeTree(AlgorithmInfo algoInfo) {
        if (!this.algorithmInfo.equals((Object)algoInfo) || this.model == null) {
            this.updateVersionTreeModel(algoInfo);
        }
    }

    class CellRenderer
    extends DefaultTreeCellRenderer {
        CellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            if (value instanceof AbstractVersionTreeNode) {
                AbstractVersionTreeNode node = (AbstractVersionTreeNode)value;
                ImageIcon icon = node.getImageIcon();
                this.setIcon(icon);
            } else {
                this.setIcon(ApplicationImages.ICON_FOLDER_16);
            }
            return this;
        }
    }

    class MouseListener
    extends MouseAdapter {
        MouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent ev) {
            this.showPopup(ev);
        }

        @Override
        public void mouseReleased(MouseEvent ev) {
            this.showPopup(ev);
        }

        private void showPopup(MouseEvent ev) {
            if (!ev.isPopupTrigger() || VersionTree.this.disablePopupMenu) {
                return;
            }
            JTree tree = (JTree)ev.getSource();
            TreePath newPath = tree.getPathForLocation(ev.getX(), ev.getY());
            if (newPath != null) {
                TreePath leadPath = VersionTree.this.getLeadSelectionPath();
                AbstractVersionTreeNode leadNode = VersionTree.this.getSelectedNode(leadPath);
                AbstractVersionTreeNode newNode = VersionTree.this.getSelectedNode(newPath);
                if (leadPath != null && newNode != null && newNode.allowMultipleSelection(leadNode)) {
                    tree.addSelectionPath(newPath);
                } else {
                    tree.setSelectionPath(newPath);
                }
                Object selected = newPath.getLastPathComponent();
                if (selected instanceof AbstractVersionTreeNode) {
                    AbstractVersionTreeNode node = (AbstractVersionTreeNode)selected;
                    node.createPopupMenu().show(tree, ev.getX(), ev.getY());
                }
            }
        }
    }

    class SelectionListener
    implements TreeSelectionListener {
        SelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent ev) {
            TreePath[] paths;
            JTree tree = (JTree)ev.getSource();
            if (tree.isSelectionEmpty() || tree.getSelectionCount() == 1) {
                VersionTree.this.disablePopupMenu = false;
                return;
            }
            AbstractVersionTreeNode leadNode = null;
            TreePath oldLeadPath = ev.getOldLeadSelectionPath();
            leadNode = oldLeadPath != null && VersionTree.this.isPathSelected(oldLeadPath) ? VersionTree.this.getSelectedNode(ev.getOldLeadSelectionPath()) : VersionTree.this.getSelectedNode(ev.getNewLeadSelectionPath());
            if (leadNode == null) {
                return;
            }
            Class<?> leadNodeClass = leadNode.getClass();
            Class<?> selectedNodeClass = null;
            TreePath[] treePathArray = paths = ev.getPaths();
            int n = paths.length;
            int n2 = 0;
            while (n2 < n) {
                TreePath aPath = treePathArray[n2];
                AbstractVersionTreeNode aSelectedNode = VersionTree.this.getSelectedNode(aPath);
                if (aSelectedNode != null) {
                    selectedNodeClass = aSelectedNode.getClass();
                }
                if (selectedNodeClass == null || !selectedNodeClass.equals(leadNodeClass)) {
                    VersionTree.this.disablePopupMenu = true;
                    return;
                }
                ++n2;
            }
            VersionTree.this.disablePopupMenu = false;
        }
    }
}

