/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.algorithmsmanager.versiontree;

import csbase.client.applications.algorithmsmanager.versiontree.VersionTreeRootNode;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class VersionTreeModel
implements TreeModel {
    private VersionTreeRootNode root;
    private List<TreeModelListener> listeners = new ArrayList<TreeModelListener>();

    public VersionTreeModel(VersionTreeRootNode root) {
        this.root = root;
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public int getChildCount(Object parent) {
        TreeNode node = (TreeNode)parent;
        return node.getChildCount();
    }

    @Override
    public boolean isLeaf(Object obj) {
        TreeNode node = (TreeNode)obj;
        return node.isLeaf();
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listeners.remove(l);
    }

    @Override
    public Object getChild(Object parent, int index) {
        TreeNode node = (TreeNode)parent;
        return node.getChildAt(index);
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        TreeNode parentNode = (TreeNode)parent;
        TreeNode childNode = (TreeNode)child;
        return parentNode.getIndex(childNode);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    private void nodesWereRemoved(DefaultMutableTreeNode parentNode, int[] removedNodesIndexes, Object[] removedNodes) {
        for (TreeModelListener listener : this.listeners) {
            TreePath path = new TreePath(parentNode.getPath());
            TreeModelEvent event = new TreeModelEvent((Object)this, path, removedNodesIndexes, removedNodes);
            listener.treeNodesRemoved(event);
        }
    }

    private void nodesWereInserted(DefaultMutableTreeNode parentNode, int[] insertedNodesIndexes, Object[] insertedNodes) {
        for (TreeModelListener listener : this.listeners) {
            TreePath path = new TreePath(parentNode.getPath());
            TreeModelEvent event = new TreeModelEvent((Object)this, path, insertedNodesIndexes, insertedNodes);
            listener.treeNodesInserted(event);
        }
    }

    private void nodeStructureChanged(DefaultMutableTreeNode parentNode) {
        for (TreeModelListener listener : this.listeners) {
            TreePath path = new TreePath(parentNode.getPath());
            TreeModelEvent event = new TreeModelEvent((Object)this, path);
            listener.treeStructureChanged(event);
        }
    }

    public void addVersion(DefaultMutableTreeNode newVersionode) {
        this.root.add(newVersionode);
        int newNodeIndex = this.root.getIndex(newVersionode);
        this.nodesWereInserted(this.root, new int[]{newNodeIndex}, new Object[]{newVersionode});
    }

    public void removeVersion(int removedNodeIndex) {
        TreeNode removedNode = this.root.getChildAt(removedNodeIndex);
        this.root.remove(removedNodeIndex);
        this.nodesWereRemoved(this.root, new int[]{removedNodeIndex}, new Object[]{removedNode});
    }

    public void setRoot(VersionTreeRootNode root) {
        this.root = root;
        this.nodeStructureChanged(root);
    }

    public boolean algorithmExists(String name) {
        Enumeration<TreeNode> children = this.root.children();
        while (children.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)children.nextElement();
            if (!node.toString().equals(name)) continue;
            return true;
        }
        return false;
    }

    public void removeAllVersions() {
        int childCount = this.root.getChildCount();
        Object[] removedNodes = new Object[childCount];
        int[] removedIndexes = new int[childCount];
        int i = 0;
        while (i < childCount) {
            TreeNode removedNode = this.root.getChildAt(i);
            this.root.remove(i);
            removedNodes[i] = removedNode;
            removedIndexes[i] = i;
            ++i;
        }
        this.nodesWereRemoved(this.root, removedIndexes, removedNodes);
    }
}

