/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.algorithmsmanager.versiontree.datatransfer;

import csbase.client.applications.algorithmsmanager.versiontree.datatransfer.ITransferableSource;
import csbase.client.applications.algorithmsmanager.versiontree.datatransfer.ITransferableTarget;
import csbase.client.applications.algorithmsmanager.versiontree.datatransfer.VersionTreeClipboard;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.InputEvent;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.tree.TreePath;

public class VersionTreeTransferHandler
extends TransferHandler {
    @Override
    public int getSourceActions(JComponent c) {
        return 1;
    }

    @Override
    public void exportToClipboard(JComponent source, Clipboard clip, int action) {
        if (clip != null) {
            throw new IllegalArgumentException("Clipboard deve ser vazio.");
        }
        Transferable transferable = this.createTransferable(source);
        if (transferable != null) {
            VersionTreeClipboard.setObject(transferable);
        }
        super.exportToClipboard(source, clip, action);
    }

    @Override
    public void exportAsDrag(JComponent source, InputEvent e, int action) {
        VersionTreeClipboard.setObject(null);
        super.exportAsDrag(source, e, action);
    }

    @Override
    public Transferable createTransferable(JComponent c) {
        if (c instanceof JTree) {
            JTree tree = (JTree)c;
            try {
                TreePath[] paths = tree.getSelectionPaths();
                if (paths == null) {
                    return null;
                }
                Serializable[] data = new Serializable[paths.length];
                DataFlavor flavor = null;
                int inx = 0;
                while (inx < data.length) {
                    Object node = paths[inx].getLastPathComponent();
                    if (ITransferableSource.class.isAssignableFrom(node.getClass())) {
                        ITransferableSource source = (ITransferableSource)node;
                        if (flavor != null && !flavor.equals(source.getDataFlavor())) {
                            return null;
                        }
                        data[inx] = source.getData();
                        flavor = source.getDataFlavor();
                    }
                    ++inx;
                }
                TransferableNode transferableNode = new TransferableNode(data, flavor);
                return transferableNode;
            }
            finally {
                tree.clearSelection();
            }
        }
        return null;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport supp) {
        ITransferableTarget target = this.getDropTarget(supp);
        if (target == null) {
            return false;
        }
        try {
            Transferable transferable = supp.getTransferable();
            Object[] data = (Object[])transferable.getTransferData(supp.getDataFlavors()[0]);
            DataFlavor flavor = transferable.getTransferDataFlavors()[0];
            return target.canImport(data, flavor);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport supp) {
        try {
            Transferable transferable = supp.getTransferable();
            Object[] data = (Object[])transferable.getTransferData(supp.getDataFlavors()[0]);
            ITransferableTarget target = this.getDropTarget(supp);
            target.importData(data);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public void exportDone(JComponent c, Transferable t, int action) {
    }

    private ITransferableTarget getDropTarget(TransferHandler.TransferSupport supp) {
        Object component;
        TreePath path = null;
        if (supp.isDrop()) {
            JTree.DropLocation dl = (JTree.DropLocation)supp.getDropLocation();
            path = dl.getPath();
        } else if (supp.getComponent() instanceof JTree) {
            path = ((JTree)supp.getComponent()).getSelectionPath();
        }
        if (path != null && (component = path.getLastPathComponent()) != null && ITransferableTarget.class.isAssignableFrom(component.getClass())) {
            return (ITransferableTarget)component;
        }
        return null;
    }

    public class TransferableNode
    implements Transferable {
        private final DataFlavor[] flavors;
        private final Serializable[] data;

        public TransferableNode(Serializable[] data, DataFlavor flavor) {
            this.data = data;
            this.flavors = new DataFlavor[]{flavor};
        }

        @Override
        public synchronized Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
            if (!this.isDataFlavorSupported(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.data;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return this.flavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            DataFlavor[] dataFlavorArray = this.flavors;
            int n = this.flavors.length;
            int n2 = 0;
            while (n2 < n) {
                DataFlavor aFlavor = dataFlavorArray[n2];
                if (aFlavor.equals(flavor)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }
}

